# Author: Bartosz Miskiewicz <mmmisiu@gmail.com> 2011

import gtk
import hildondesktop
import hildon
import os

# class representing a button in a grid
class MmmAudioButton(gtk.Button):
    # field to remember which sound file to play after press
    sound_file = ''
    def __init__(self, name):
        gtk.Button.__init__(self)
        self.set_label(name)
    # function connected later to clicked event
    def play_sound(self, caller):
        os.system('echo "' + self.sound_file + '"')
        os.system('play-sound "' + self.sound_file + '"');

# class representing single button editing dialog in configuration
class MmmAudioButtonConfig():
    # string displayed on the button
    button_name = ''
    # sound file played after click event
    sound_file = ''
    # dialog
    dialog = ''
    button = ''
    entry = ''
    def __init__(self):
        self.button_name = ''
        self.sound_file = ''
    def button_was_clicked(self, caller):
        chooser = hildon.FileChooserDialog(self.dialog, gtk.FILE_CHOOSER_ACTION_OPEN)
        response = chooser.run()
        chooser.hide_all()
        if response == gtk.RESPONSE_OK:
            self.sound_file = chooser.get_filename()
            self.dialog.hide_all()
            self.button_name = self.entry.get_text()
            self.recreate_dialog()
            self.dialog.show_all()
    def run(self):
        self.recreate_dialog()
        self.dialog.show_all()
        while True:
            result = self.dialog.run()
            if result == 1:
                # save
                self.button_name = self.entry.get_text()
                break
            elif result == 2:
                # cancel
                break
        self.dialog.destroy()
        return result
    def recreate_dialog(self):
        self.dialog = gtk.Dialog('mmmAudioWidget button configuration', None,
                             gtk.DIALOG_DESTROY_WITH_PARENT,
                             ('Save', 1, 'Cancel', 2))
        self.entry = hildon.Entry(gtk.HILDON_SIZE_AUTO)
        self.entry.set_text(self.button_name)
        self.button = gtk.Button(self.sound_file)
        self.button.connect('clicked', self.button_was_clicked)
        pan = hildon.PannableArea()
        options = gtk.VBox()
        pan.add_with_viewport(options)
        self.dialog.vbox.pack_start(pan)
        options.pack_start(gtk.Label('Text displayed on button:'))
        options.pack_start(self.entry)
        options.pack_start(gtk.Label('Path to sound file:'))
        options.pack_start(self.button)
        self.dialog.set_size_request(800, 400)

# class representing widget
class MmmAudioWidgetPlugin(hildondesktop.HomePluginItem):
    # table holding positions of all buttons, overriden while reading config
    table = gtk.Table(1, 1, True)
    # number of buttons in col and row, overriden while reading config
    buttonsCount = [1, 1]
    # size of single button, overriden while reading config
    size = [100, 100]
    # array of elements in format ButtonLabel:/path/to/sound/file.extension
    # overriden while reading config
    # also, two first lines of this are NoOfRows:NoOfCols and RowSize:ColSize after config
    elements = ['1:1', '100:100', 'Raz:/home/user/MyDocs/sound.wav']
    # array of buttons, overriden while reading config
    buttons = []
    # variable to know if widget is after initialization or not
    after_init = False
    # elements of settings dialog
    dialog = ''
    selector = ''
    pan = ''
    selected = ''
    options = ''
    # plugin constructor
    def __init__(self):
        hildondesktop.HomePluginItem.__init__(self)
        # reading config and changing size/buttons accordingly
        self.refresh_view()
        # inform hildon-menu, that we also have settings dialog present
	self.set_settings(True)
	self.connect('show-settings', self.show_settings_dialog)
        after_init = True
    # function displaying settings dialog
    def show_settings_dialog(self, plugin):
        self.recreate_dialog()
        # while noone clicked "Save" or "Cancel", continue to edit configuration
        running = True
        while running:
            # show dialog
            self.dialog.show_all()
            # wait for pressing a button
            response = self.dialog.run()
            # hide dialog and later act accordingly
            self.dialog.hide()
            if response == 1:
                # save changes
                writefile = open('/home/user/.mmmaudiowidget/config.txt', 'w');
                # widget cannot be bigger, than screen
                # because it would be impossible to configure or delete it
                if int(self.buttonsCount[0])*int(self.size[0]) > 780:
                    self.size[0] = str( 780/int(self.buttonsCount[0]) )
                if int(self.buttonsCount[1])*int(self.size[1]) > 430:
                    self.size[1] = str( 430/int(self.buttonsCount[1]) )
                writefile.write(self.buttonsCount[0] + ':' + self.buttonsCount[1] + '\n')
                writefile.write(self.size[0] + ':' + self.size[1] + '\n')
                for i in range(2, len(self.elements)):
                    writefile.write(self.elements[i] + '\n')
                writefile.close()
                running = False
                break
            elif response == 3:
                # change number of buttons - new dialog
                dialog2 = gtk.Dialog('mmmAudioWidget size of grid', None,
                                     gtk.DIALOG_DESTROY_WITH_PARENT, 
                                     ('Save', 1, 
                                     'Cancel', 2))
                pan2 = hildon.PannableArea()
                options2 = gtk.VBox()
                pan2.add_with_viewport(options2)
                dialog2.vbox.pack_start(pan2)
                options21 = gtk.HBox()
                options2.add(options21)
                options21.pack_start(gtk.Label('Columns (value from 1 to 8)'))
                entry21 = hildon.Entry(gtk.HILDON_SIZE_AUTO)
                entry21.set_text(self.buttonsCount[0])
                options21.pack_start(entry21)
                options22 = gtk.HBox()
                options2.add(options22)
                options22.pack_start(gtk.Label('Rows (value from 1 to 5)'))
                entry22 = hildon.Entry(gtk.HILDON_SIZE_AUTO)
                entry22.set_text(self.buttonsCount[1])
                options22.pack_start(entry22)
                dialog2.show_all()
                response2 = dialog2.run()
                if response2 == 1:
                    self.buttonsCount[0] = self.validate_input(entry21.get_text(), 1, 8, 1)
                    self.buttonsCount[1] = self.validate_input(entry22.get_text(), 1, 5, 2)
                dialog2.destroy()
            elif response == 4:
                # change button size - new dialog
                dialog3 = gtk.Dialog('mmmAudioWidget size of button', None,
                                     gtk.DIALOG_DESTROY_WITH_PARENT, 
                                     ('Save', 1, 
                                     'Cancel', 2))
                pan3 = hildon.PannableArea()
                options3 = gtk.VBox()
                pan3.add_with_viewport(options3)
                dialog3.vbox.pack_start(pan3)
                options31 = gtk.HBox()
                options3.add(options31)
                options31.pack_start(gtk.Label('Width (value from 80 to 390)'))
                entry31 = hildon.Entry(gtk.HILDON_SIZE_AUTO)
                entry31.set_text(self.size[0])
                options31.pack_start(entry31)
                options32 = gtk.HBox()
                options3.add(options32)
                options32.pack_start(gtk.Label('Height (value from 50 to 215)'))
                entry32 = hildon.Entry(gtk.HILDON_SIZE_AUTO)
                entry32.set_text(self.size[1])
                options32.pack_start(entry32)
                dialog3.show_all()
                response3 = dialog3.run()
                if response3 == 1:
                    self.size[0] = self.validate_input(entry31.get_text(), 80, 390, 3)
                    self.size[1] = self.validate_input(entry32.get_text(), 50, 215, 4)
                dialog3.destroy()
            elif response == 5:
                # edit selected
                tab = self.selected.get_active()
                tmp = self.elements[int(tab)+2].split(':')
                editdialog = MmmAudioButtonConfig()
                editdialog.button_name = tmp[0]
                editdialog.sound_file = tmp[1]
                response5 = editdialog.run()
                if response5 == 1:
                    # save
                    self.elements[int(tab)+2] = editdialog.button_name + ':' + editdialog.sound_file
                self.recreate_dialog()
            elif response == 2:
                # cancel
                running = False
                break
        # destroy configuration window, as it is not longer needed
        self.dialog.destroy()
        # and reload widget view, because it might have been changed by user
        self.refresh_view()
    # function to create settings dialog
    def recreate_dialog(self):
        self.dialog = gtk.Dialog('mmmAudioWidget configuration', None,
                            gtk.DIALOG_DESTROY_WITH_PARENT, 
                            ('Save changes', 1, 
                             'Cancel', 2, 
                             'Edit selected', 5, 
                             'No. of buttons', 3, 
                             'Button size', 4))
        # creating list of visible buttons to combobox
        self.selector = hildon.TouchSelector(text=True)
        for i in range(0, int(self.buttonsCount[0])*int(self.buttonsCount[1])):
            tmp = self.elements[i+2].split(':')
            self.selector.append_text(str(i+1) + ': ' + tmp[0])
        self.selector.select_iter(0, self.selector.get_model(0).get_iter(0), False)
        self.pan = hildon.PannableArea()
        self.options = gtk.VBox()
        self.pan.add_with_viewport(self.options)
        self.dialog.vbox.pack_start(self.pan)
        self.selected = hildon.PickerButton(gtk.HILDON_SIZE_AUTO_WIDTH |
                                         gtk.HILDON_SIZE_AUTO_HEIGHT,
                                       hildon.BUTTON_ARRANGEMENT_HORIZONTAL)
        self.selected.set_title('Selected:')
        self.selected.set_selector(self.selector)
        self.options.pack_start(gtk.Label('Select button to edit:'))
        self.options.pack_start(self.selected)
        self.options.pack_start(gtk.Label(' '))
        self.options.pack_start(gtk.Label(' '))
        self.options.pack_start(gtk.Label('The widget was developed by:'))
        self.options.pack_start(gtk.Label('Bartosz Miskiewicz <miskiewisz.bartosz@gmail.com>'))
    # function to load configuration and change appearance of widget accordingly
    def refresh_view(self):
        # don't display for a moment
        if self.after_init == True:
            self.hide_all()
        # check if we have configuration file present, if not - create it
        if os.path.isdir('/home/user/.mmmaudiowidget') == False:
            os.mkdir('/home/user/.mmmaudiowidget')
        if os.path.isfile('/home/user/.mmmaudiowidget/config.txt') == False :
            tmpwritefile = open('/home/user/.mmmaudiowidget/config.txt', 'w');
            tmpwritefile.write('2:2\n200:150\n')
            tmpwritefile.close()
        # read configuration file to string
        readfile = open('/home/user/.mmmaudiowidget/config.txt', 'r');
	linestring = readfile.read()
        # split it to lines
        self.elements = linestring.splitlines()
        # get number of rows and cols from the first line
        self.buttonsCount = self.elements[0].split(':')
        # get height and width of button from second line
        self.size = self.elements[1].split(':')
        # resize widget to these sizes
        self.set_size_request(int(self.size[0])*int(self.buttonsCount[0]), 
                              int(self.size[1])*int(self.buttonsCount[1]))
        self.resize(int(self.size[0])*int(self.buttonsCount[0]), 
                              int(self.size[1])*int(self.buttonsCount[1]))
        # destroy previous layout and create new
        self.table.destroy()
        self.table = gtk.Table(int(self.buttonsCount[1]), int(self.buttonsCount[0]), True)
        # destroy previous buttons table and create new
        self.buttons = []
        for i in range(0, int(self.buttonsCount[1])):
            for j in range(0, int(self.buttonsCount[0])):
                # if we have config for all visible buttons - read it, if not - fill it with
                # special fake values
                if i*int(self.buttonsCount[0])+j+2 >= len(self.elements):
                    self.elements.append('Empty:/home/user/MyDocs/sound.wav')
                tmp = self.elements[i*int(self.buttonsCount[0])+j+2].split(':')
                # add button with label to button array
                self.buttons.append(MmmAudioButton(tmp[0]))
                # set a path to sound file for it
                self.buttons[i*int(self.buttonsCount[0])+j].sound_file = tmp[1]
                # connect click event with button's personal handler - function play_sound()
                self.buttons[i*int(self.buttonsCount[0])+j].connect('clicked', 
                                     self.buttons[i*int(self.buttonsCount[0])+j].play_sound)
                # make button visible
                self.buttons[i*int(self.buttonsCount[0])+j].show_all()
                # place button in its correct place in the layout table
                self.table.attach(self.buttons[i*int(self.buttonsCount[0])+j], j, j+1, i, i+1)
        # if elements array has less than 42 elements, add them
        if len(self.elements) < 42:
            for i in range(len(self.elements), 42):
                self.elements.append('Empty:/home/user/MyDocs/sound.wav')
        # make table (and all buttons) visible
        self.table.show_all()
        # make this table visible in widget space on screen
        self.add(self.table)
        # close config file
        readfile.close()
        # display again
        if self.after_init == True:
            self.show_all()
    # ugly function validating if input of button and grid dimensions is correct
    def validate_input(self, text, minval, maxval, from_where):
        while True:
            try:
                tmp = int(text)
                if minval <= tmp <= maxval:
                    return str(tmp)
                elif minval > tmp:
                    return str(minval)
                else:
                    return str(maxval)
            except ValueError:
                if from_where == 1:
                    return str(self.buttonsCount[0])
                elif from_where == 2:
                    return str(self.buttonsCount[1])
                elif from_where == 3:
                    return str(self.size[0])
                else:
                    return str(self.size[1])

# this below is just copied from example
hd_plugin_type = MmmAudioWidgetPlugin
if __name__ == "__main__":
    import gobject
    gobject.type_register(hd_plugin_type)
    obj = gobject.new(hd_plugin_type, plugin_id="plugin_id")
    obj.show_all()
    gtk.main()
