#ifndef SHAREDIALOG_H
#define SHAREDIALOG_H

#include <QDialog>
#include <QFileDialog>
#include "localisation.h"
#include "minidlnashare.h"

namespace Ui {
    class ShareDialog;
}

class ShareDialog : public QDialog
{
    Q_OBJECT

public:
    enum ScreenOrientation {
        ScreenOrientationLockPortrait,
        ScreenOrientationLockLandscape,
        ScreenOrientationAuto
    };
    explicit ShareDialog(MiniDLNAShare *share, Localisation *lc, QWidget *parent = 0);
    ~ShareDialog();

    void setOrientation(ScreenOrientation orientation);
    void showExpanded();

private slots:
    void on_pushButton_ok_clicked();

    void on_pushButton_abort_clicked();

    void on_pushButton_selectfolder_clicked();

private:
    Ui::ShareDialog *ui;
    Localisation *lc;
    MiniDLNAShare *share;
};

#endif // SHAREDIALOG_H
