// checksum 0xa193 version 0x30001
/*
  This file was generated by the Mobile Qt Application wizard of Qt Creator.
  MainWindow is a convenience class containing mobile device specific code
  such as screen orientation handling.
  It is recommended not to modify this file, since newer versions of Qt Creator
  may offer an updated version of it.
*/

#include "mainwindow.h"
#include "ui_mainwindow.h"

#include <QtCore/QCoreApplication>
#include <QDebug>

MainWindow::MainWindow(QWidget *parent)
    : QMainWindow(parent), ui(new Ui::MainWindow)
{
    lc = new Localisation(this);
    ui->setupUi(this);
    ui->label_status->setPixmap(QPixmap(":/status/offline.gif"));
    createContextMenu();
    ui->actionAbout->setText(lc->AbTitelString());
    connect(ui->actionAbout,SIGNAL(triggered()),this,SLOT(aboutClicked()));

    ui->label_shares->setText(lc->LbSharesString());
    ui->pushButton_stop->setText(lc->PbStopString());
    ui->pushButton_startstop->setText(lc->PbStartString());
    ui->pushButton_stop->setEnabled(false);
    minidlna = new MiniDLNA(this);

    connect(minidlna,SIGNAL(ServerStatus(bool)),this,SLOT(ServerStatusChanged(bool)));
    minidlna->UpdateFromConfFile();
    minidlna->GetServerStatus();
    UpdateList();


}

MainWindow::~MainWindow()
{
    delete ui;
}

void MainWindow::setOrientation(ScreenOrientation orientation)
{
#if defined(Q_OS_SYMBIAN)
    // If the version of Qt on the device is < 4.7.2, that attribute won't work
    if (orientation != ScreenOrientationAuto) {
        const QStringList v = QString::fromAscii(qVersion()).split(QLatin1Char('.'));
        if (v.count() == 3 && (v.at(0).toInt() << 16 | v.at(1).toInt() << 8 | v.at(2).toInt()) < 0x040702) {
            qWarning("Screen orientation locking only supported with Qt 4.7.2 and above");
            return;
        }
    }
#endif // Q_OS_SYMBIAN

    Qt::WidgetAttribute attribute;
    switch (orientation) {
#if QT_VERSION < 0x040702
    // Qt < 4.7.2 does not yet have the Qt::WA_*Orientation attributes
    case ScreenOrientationLockPortrait:
        attribute = static_cast<Qt::WidgetAttribute>(128);
        break;
    case ScreenOrientationLockLandscape:
        attribute = static_cast<Qt::WidgetAttribute>(129);
        break;
    default:
    case ScreenOrientationAuto:
        attribute = static_cast<Qt::WidgetAttribute>(130);
        break;
#else // QT_VERSION < 0x040702
    case ScreenOrientationLockPortrait:
        attribute = Qt::WA_LockPortraitOrientation;
        break;
    case ScreenOrientationLockLandscape:
        attribute = Qt::WA_LockLandscapeOrientation;
        break;
    default:
    case ScreenOrientationAuto:
        attribute = Qt::WA_AutoOrientation;
        break;
#endif // QT_VERSION < 0x040702
    };
    setAttribute(attribute, true);
}

void MainWindow::showExpanded()
{
#ifdef Q_OS_SYMBIAN
    showFullScreen();
#elif defined(Q_WS_MAEMO_5) || defined(Q_WS_MAEMO_6)
    showMaximized();
#else
    show();
#endif
}

void MainWindow::ServerStatusChanged(bool state)
{
    if(state)
    {
        ui->pushButton_startstop->setEnabled(false);
        ui->pushButton_stop->setEnabled(true);
        ui->label_status->setPixmap(QPixmap(":/status/online.gif"));
    }
    else
    {
        ui->pushButton_startstop->setEnabled(true);
        ui->pushButton_stop->setEnabled(false);
        ui->label_status->setPixmap(QPixmap(":/status/offline.gif"));
    }
}


void MainWindow::on_pushButton_startstop_clicked()
{
    minidlna->StartServer();
}

void MainWindow::UpdateList()
{
    ui->listWidget->clear();
    shares = minidlna->GetShares();
    for(int i=0;i<shares.size();i++)
    {
        if(shares[i].Name==".images")
            ui->listWidget->addItem(lc->FoPicturesString());
        else if(shares[i].Name==".videos")
            ui->listWidget->addItem(lc->FoVideosString());
        else if(shares[i].Name==".sounds")
            ui->listWidget->addItem(lc->FoSoundsString());
        else
            ui->listWidget->addItem(shares[i].Name);
    }
}

void MainWindow::createContextMenu()
{
    // Define context menu for the QListWidget
    ui->listWidget->setContextMenuPolicy(Qt::CustomContextMenu);

    // Connect to customContextMenuRequested signal
    QObject::connect(ui->listWidget, SIGNAL(customContextMenuRequested(const QPoint&)),
    this, SLOT(showContextMenu(const QPoint&)));

    // Context menu for QListWidget
    m_contextMenu = new QMenu(this);

    // Create one action item

    addAction = new QAction(lc->CmAddString(),0);
    editAction = new QAction(lc->CmEditString(),0);
    removeAction = new QAction(lc->CmRmString(),0);

    connect(addAction, SIGNAL(triggered()), this, SLOT(addClicked()));
    connect(editAction, SIGNAL(triggered()), this, SLOT(editClicked()));
    connect(removeAction, SIGNAL(triggered()), this, SLOT(removeClicked()));
    m_contextMenu->addAction(addAction);
    m_contextMenu->addAction(editAction);
    m_contextMenu->addAction(removeAction);
}

void MainWindow::showContextMenu(const QPoint& pos)
{
    if(ui->listWidget->selectedItems().size()==0)
    {
        editAction->setEnabled(false);
        removeAction->setEnabled(false);
    }
    else
    {
        editAction->setEnabled(true);
        removeAction->setEnabled(true);
    }
    // If statement is workaround for QTBUG-6256
    if (pos != QPoint(0,0)) {
        // Execute context menu
        m_contextMenu->exec(pos);
    }
}

void MainWindow::addClicked()
{
    MiniDLNAShare share;
    ShareDialog *sdlg = new ShareDialog(&share,lc,this);
    sdlg->setOrientation(ShareDialog::ScreenOrientationAuto);
    if(sdlg->exec()==1)
    {
        if(share.Path!="")
        {
            if(!shares.contains(share))
                shares.append(share);


            minidlna->SetShares(shares);
            minidlna->AcceptChanges();
            UpdateList();
        }
    }
}

void MainWindow::editClicked()
{
    int cindex = ui->listWidget->currentRow();
    if(cindex>=shares.size())
        return;
    MiniDLNAShare old = shares[cindex];
    ShareDialog *sdlg = new ShareDialog(&shares[cindex],lc,this);
    if(sdlg->exec()==1)
    {
        if(shares[cindex].Path!="")
        {
            minidlna->SetShares(shares);
            minidlna->AcceptChanges();
            UpdateList();
        }
        else
        {
            shares[cindex] = old;
            UpdateList();
        }
    }
    else
    {
        shares[cindex] = old;
        UpdateList();
    }
}

void MainWindow::removeClicked()
{
    int cindex = ui->listWidget->currentRow();
    if(cindex>=shares.size())
        return;
    shares.removeAt(cindex);
    minidlna->SetShares(shares);
    minidlna->AcceptChanges();
    UpdateList();
}

void MainWindow::on_pushButton_stop_clicked()
{
    minidlna->StopServer();
}

void MainWindow::aboutClicked()
{
    AboutDialog *adlg = new AboutDialog(lc);
    adlg->setOrientation(AboutDialog::ScreenOrientationAuto);
    adlg->exec();
}
