#include "localisation.h"

Localisation::Localisation(QObject *parent) :
    QObject(parent)
{
    if(QLocale::system().name()=="de_DE")
        SetGerman();
    else
        SetEnglish();
}

QString Localisation::PbStartString()
{
    return pb_start;
}

QString Localisation::PbStopString()
{
    return pb_stop;
}

QString Localisation::PbCloseString()
{
    return pb_close;
}
QString Localisation::PbOkString()
{
    return pb_ok;
}
QString Localisation::PbAbortString()
{
    return pb_abort;
}
QString Localisation::PbSelectFolderString()
{
    return pb_selectfolder;
}

QString Localisation::RbAudioString()
{
    return rb_audio;
}
QString Localisation::RbImagesString()
{
    return rb_images;
}
QString Localisation::RbNoneString()
{
    return rb_none;
}
QString Localisation::RbVideoString()
{
    return rb_video;
}

QString Localisation::LbSharesString()
{
    return lb_shares;
}
QString Localisation::LbFolderString()
{
    return lb_folder;
}
QString Localisation::LbTypeString()
{
    return lb_type;
}

QString Localisation::FoPicturesString()
{
    return fo_pictures;
}
QString Localisation::FoVideosString()
{
    return fo_videos;
}
QString Localisation::FoSoundsString()
{
    return fo_sounds;
}

QString Localisation::CmAddString()
{
    return cm_add;
}
QString Localisation::CmEditString()
{
    return cm_edit;
}
QString Localisation::CmRmString()
{
    return cm_remove;
}

QString Localisation::AbTitelString()
{
    return ab_titel;
}
QString Localisation::AbAutorString()
{
    return ab_autor;
}

void Localisation::SetGerman()
{
    pb_start = "DLNA aktivieren";
    pb_stop = "DLNA deaktivieren";
    pb_close = "Schlieen";
    pb_ok = "Ok";
    pb_abort = "Abbrechen";
    pb_selectfolder = "Ordner auswhlen";

    rb_none = "Kein";
    rb_video = "Videos";
    rb_audio = "Musik";
    rb_images = "Bilder";

    lb_shares = "Medien-Verzeichnisse:";
    lb_folder = "Ordner:";
    lb_type = "Typ:";

    fo_pictures = "Bilder";
    fo_videos = "Videos";
    fo_sounds = "Musik";

    cm_add = "Hinzufgen";
    cm_edit = "Bearbeiten";
    cm_remove = "Lschen";

    ab_titel = "ber...";
    ab_autor = "Autor: Karl Wintermann\nE-Mail: karl@rx-51.de\n\nCopyright: 2011, Karl Wintermann";

}

void Localisation::SetEnglish()
{
    pb_start = "Start DLNA";
    pb_stop = "Stop DLNA";
    pb_close = "Close";
    pb_ok = "Ok";
    pb_abort = "Abort";
    pb_selectfolder = "Select folder";

    rb_none = "None";
    rb_video = "Videos";
    rb_audio = "Music";
    rb_images = "Pictures";

    lb_shares = "Media directorys:";
    lb_folder = "Folder:";
    lb_type = "Type:";

    fo_pictures = "Pictures";
    fo_videos = "Videos";
    fo_sounds = "Music";

    cm_add = "Add";
    cm_edit = "Edit";
    cm_remove = "Remove";

    ab_titel = "About...";
    ab_autor = "Author: Karl Wintermann\nMail: karl@rx-51.de\n\nCopyright: 2011, Karl Wintermann";


}

