/*
 *  Microfeed - Backend for accessing feed-based services (utils)
 *  Copyright (C) 2009 Henrik Hedberg <henrik.hedberg@innologies.fi>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License version 2 as published by
 *  the Free Software Foundation.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

#ifndef CONFIGURATION_H_
#define CONFIGURATION_H_

#include <gtk/gtk.h>
#ifdef MAEMO_CHANGES
#include <hildon/hildon.h>
#endif
#include <microfeed-subscriber/microfeedsubscriber.h>

void show_wizard_dialog(MicrofeedSubscriber* subscriber, GtkWindow* parent, const char* identifier);
void show_publishers_dialog(MicrofeedSubscriber* subscriber, GtkWindow* parent, const char* identifier);
char* show_new_dialog(MicrofeedSubscriber* subscriber, GtkWindow* parent);
void show_edit_dialog(MicrofeedSubscriber* subscriber, GtkWindow* parent, const char* publisher, int just_created);
void show_value_dialog(MicrofeedSubscriber* subscriber, GtkWindow* parent, const char* publisher, const char* uid, const char* text, const char* value, const char* unit, const char* type, int length);

#endif
