#ifndef MIAMO_H
#define MIAMO_H
#include <QtCore>
#include <QtGui>
#include "ui_miano.h"
#include "gst/gst.h"

class Miano : public QMainWindow, private Ui::Piano {
	Q_OBJECT

public:
	Miano(QMainWindow *parent = 0);


private:
	void setupActions();
	void setupEffect();
	double getSpeed(int);
	int octave;
	GstElement *sink;
    GstElement *pipeline, *source, *convert, *convert2, *decode, *speed, *parse, *demux;
	QAction *pianoAct;
	QAction *organAct;
	QAction *sampleAct;
	
private slots:
	void stopSound();
	void playab();
	void playabb();
	void playhb();
	void playcb();
	void playcbb();
	void playdb();
	void playdbb();
	void playeb();
	void playfb();
	void playfbb();
	void playgb();
	void playgbb();
	void playab2();
	void playabb2();
	void playhb2();
	void octaveUp();
	void octaveDown();
	void setPiano();
	void setOrgan();
	void setSample();

};


#endif
