#ifndef MAINWINDOW_H
#define MAINWINDOW_H
#include <QtGui/QMainWindow>
#include <QDeclarativeView>
#include <MyClass.h>

#ifdef Q_WS_MAEMO_5
#include <mce/mode-names.h>
#include <mce/dbus-names.h>
#endif


namespace Ui {
    class MainWindow;
}

//class QDeclarativeView;


class MainWindow : public QMainWindow
{
    Q_OBJECT
public:
    enum Orientation {
        LockPortrait,
        LockLandscape,
        Auto
    };

    MainWindow(QWidget *parent = 0);
    ~MainWindow();

    void setOrientation(Orientation orientation);
//    QDeclarativeView view;

public slots:
    void rejectButtonClicked();
    void displayFakeCallMaximized();
    void setCallerNameLabel(QString name);
    void setCallerPicLabel(QString picpath);
    void setCallRingTone(QString tonepath);
    void setCallWallpaper(QString wallpaperpath);
    void setCallerDefaults();
    void unLockN900();

private:
    Ui::MainWindow *ui;
    MyClass *myClass;
    QString initialCallID;
    QString initialCallerPicPath;
    QString initialCallerRingtonePath;
    QString initialCallWallpaper;
    QDBusInterface *mDbusInterface;
};

#endif // MAINWINDOW_H
