#include "mainwindow.h"
#include "ui_mainwindow.h"
#include <QTextStream>
#include <QTimer>
#include <phonon>
#include <qstringbuilder.h>
#include <QtDBus>

#ifdef Q_WS_MAEMO_5
#include <mce/mode-names.h>
#include <mce/dbus-names.h>
#endif

/*
 mFakeCaller mainwindow.cpp
 Called from main.cpp, displays mFakeCaller UI form to simulate incoming phone call.
 Written by Ryan Faulkner (Kojacker, maemo.org forums)
 Email ryanfprojects at gmail.com
 7 Nov 2010
 */

MainWindow::MainWindow(QWidget *parent) :
    QMainWindow(parent),
    ui(new Ui::MainWindow)
{
    //QTextStream out(stdout);

    ui->setupUi(this);

    #if defined(Q_WS_MAEMO_5)|| defined(Q_WS_HILDON)
        setAttribute(Qt::WA_Maemo5PortraitOrientation, true);
    #endif

    release_timer = new QTimer(this);
    release_timer->setInterval(21000);
    connect(release_timer, SIGNAL(timeout()), this, SLOT(close()));

    mediaObject = new Phonon::MediaObject(this);
    Phonon::AudioOutput *audioOutput =
    new Phonon::AudioOutput(Phonon::MusicCategory, this);
    Phonon::Path path = Phonon::createPath(mediaObject, audioOutput);
    audioOutput->setVolume(0.9);

    connect(mediaObject, SIGNAL(finished()), this, SLOT(repeatRingTone()));
    ui->callDurationLabel->setVisible(false);
    callDuration = 0;

    #ifdef Q_WS_MAEMO_5
    mDbusInterface = new QDBusInterface(MCE_SERVICE, MCE_REQUEST_PATH,
                                     MCE_REQUEST_IF, QDBusConnection::systemBus(),
                                     this);
    #endif
}

MainWindow::~MainWindow()
{
    #ifdef Q_WS_MAEMO_5
    mDbusInterface->call(MCE_DEACTIVATE_VIBRATOR_PATTERN, "PatternIncomingCall");
    #endif
    delete ui;
}

void MainWindow::setCallerNameLabel(QString name)
{
    ui->callerName->setText(name);
}

void MainWindow::setCallerPicLabel(QString picpath)
{
    ui->callerPicLabel->setPixmap(picpath);
}

void MainWindow::setCallRingTone(QString tonePath)
{
    ringTonePath = tonePath;
    mediaObject->setCurrentSource(Phonon::MediaSource(tonePath));
    mediaObject->play();
    mDbusInterface->call(MCE_ENABLE_VIBRATOR);

    mDbusInterface->call(MCE_ACTIVATE_VIBRATOR_PATTERN, "PatternIncomingCall");
    mDbusInterface->call(MCE_TKLOCK_MODE_CHANGE_REQ, "unlocked");
}

void MainWindow::setBackgroundStyleSheet(QString backgroundStyles)
{
    ui->backgroundLabel->setStyleSheet(backgroundStyles);
}

void MainWindow::changeEvent(QEvent *e)
{
    QMainWindow::changeEvent(e);
    switch (e->type()) {
    case QEvent::LanguageChange:
        ui->retranslateUi(this);
        break;
    default:
        break;
    }
}

void MainWindow::repeatRingTone()
{
    mediaObject->setCurrentSource(Phonon::MediaSource(ringTonePath));
    mediaObject->play();
}

void MainWindow::stopVibration()
{
    #ifdef Q_WS_MAEMO_5
    mDbusInterface->call(MCE_DEACTIVATE_VIBRATOR_PATTERN, "PatternIncomingCall");
    #endif
}

void MainWindow::updateCallDuration()
{
    callDuration+=1000;
    int Hours;
    int Minutes;
    int Seconds;
    QString hourString;
    QString minString;
    QString secString;

    //Convert milliseconds to hours:minutes:seconds
    Hours = callDuration / (1000*60*60);
    Minutes = (callDuration % (1000*60*60)) / (1000*60);
    Seconds = ((callDuration % (1000*60*60)) % (1000*60)) / 1000;

    hourString = (QString::number(Hours));
    if (Hours<10){
        hourString.prepend("0");
    }

    minString = (QString::number(Minutes));
    if (Minutes<10){
        minString.prepend("0");
    }

    secString = (QString::number(Seconds));
    if (Seconds<10){
        secString.prepend("0");
    }

    ui->callDurationLabel->setText(hourString + ":" + minString + ":" + secString);
}

void MainWindow::leftUnassignedButtonClicked()
{
    stopVibration();
}

void MainWindow::answerButtonClicked()
{
    disconnect(ui->answerButton, SIGNAL(clicked()), this, SLOT(answerButtonClicked()));
    disconnect(release_timer, SIGNAL(timeout()), this, SLOT(close()));
    release_timer->setInterval(1000);
    release_timer->setSingleShot(false);
    ui->callDurationLabel->setVisible(true);
    connect(release_timer, SIGNAL(timeout()), this, SLOT(updateCallDuration()));
    ui->answerButton->setText("Speaker");
    ui->answerButton->setStyleSheet("QPushButton { background-color: qlineargradient(spread:pad, x1:0, y1:1, x2:0, y2:0, stop:0.607955 rgba(46, 37, 32, 255), stop:0.875 rgba(60, 56, 64, 255)); }");
    ui->rejectButton->setText("End");
    mediaObject->stop();
    stopVibration();
}

void MainWindow::rejectButtonClicked()
{
    stopVibration();
    close();
}


