#include "settingswindow.h"

SettingsWindow::SettingsWindow(QWidget *parent) :
        QMainWindow(parent)
{
    QWidget *widget = new QWidget;
    setCentralWidget(widget);

    QVBoxLayout *vLayout = new QVBoxLayout;

    btnExercise = new QPushButton("Exercise");
    connect(btnExercise,SIGNAL(clicked()),this,SLOT(showExerciseSettings()));
    vLayout->addWidget(btnExercise);

    btnOther = new QPushButton("Other");
    connect(btnOther,SIGNAL(clicked()),this,SLOT(showOtherSettings()));
    vLayout->addWidget(btnOther);

    btnNewExercise = new QPushButton("Edit exercises");
    connect(btnNewExercise,SIGNAL(clicked()),this,SLOT(showExercise()));
    vLayout->addWidget(btnNewExercise);

    btnNewProgram = new QPushButton("Edit programs");
    connect(btnNewProgram,SIGNAL(clicked()),this,SLOT(showProgram()));
    vLayout->addWidget(btnNewProgram);



    widget->setLayout(vLayout);

}

void SettingsWindow::showExercise()
{
    ew = new EditWindow(this);
    ew->load("Exercise");
    ew->show();
}

void SettingsWindow::showProgram()
{
    ew = new EditWindow(this);
    ew->load("Program");
    ew->show();
}

void SettingsWindow::showOtherSettings()
{
    os = new OtherSettings(this);
    os->show();
}
void SettingsWindow::showExerciseSettings()
{
    es = new ExerciseSettings(this);
    es->show();
}
