#include "selectexercise.h"

SelectExercise::SelectExercise(QWidget *parent) :
        QDialog(parent)
{
    setWindowTitle("Choose exercise");

    QHBoxLayout *hLayout = new QHBoxLayout();

    lstExercises = new QListView();
    model = new QStandardItemModel(this);
    lstExercises->setModel(model);
    hLayout->addWidget(lstExercises);

    btnStart = new QPushButton("Start");
    connect(btnStart, SIGNAL(clicked()),this,SLOT(start()));
    hLayout->addWidget(btnStart);

    resize(480,550);
    setLayout(hLayout);
}

void SelectExercise::load(QStringList exercises)
{
    close = false;
    while(!exercises.isEmpty())
    {
        model->appendRow(new QStandardItem(exercises.takeFirst()));
    }
    model->sort(0);
}

void SelectExercise::start()
{
    close = true;
    QString name = lstExercises->currentIndex().data().toString();
    qDebug() << "se: " << name;
    emit exerciseName(name);

    delete this;
}

void SelectExercise::closeEvent(QCloseEvent *event)
{
    if(close == false)
        return event->ignore();
}
