#include "programinfo.h"

ProgramInfo::ProgramInfo(QWidget *parent) :
    QMainWindow(parent)
{
    QWidget *widget = new QWidget;
    setCentralWidget(widget);
    QVBoxLayout *vLayout = new QVBoxLayout;

    sql = new SQL();
    model = new QStandardItemModel(this);

    lstExercises = new QListView();
    lstExercises->setModel(model);

    //lstExercises->setContextMenuPolicy(Qt::CustomContextMenu);
    //connect(lstExercises, SIGNAL(customContextMenuRequested(const QPoint &)),SLOT(showContextMenuForWidget(const QPoint &)));

    vLayout->addWidget(lstExercises);

    btnStart = new QPushButton("Start");
    connect(btnStart,SIGNAL(clicked()),this,SLOT(startProgram()));
    vLayout->addWidget(btnStart);
    widget->setLayout(vLayout);
}

void ProgramInfo::startProgram()
{
    ew = new ExerciseWindow(this);
    ew->loadExercises(sql->loadProgram(program));
    ew->show();
}

void ProgramInfo::loadExercises(QString prog)
{
    QStringList list;
    program = prog;
    Program *p = sql->loadProgram(prog);
    list = p->getExerciseNames();

    model->clear();
    lstExercises->setSelectionMode(QListView::SingleSelection);
    connect(lstExercises,SIGNAL(clicked(QModelIndex)),this,SLOT(showInfo(QModelIndex)));

    if(list.isEmpty())
    {
        model->appendRow(new QStandardItem ("No exercises"));

        lstExercises->setSelectionMode(QListView::NoSelection);
        return;
    }

    while(!list.isEmpty())
    {
        model->appendRow(new QStandardItem(list.takeFirst()));
    }

    model->sort(0);
}
