#include "newprogram.h"

NewProgram::NewProgram(QWidget *parent) :
    QMainWindow(parent)
{
    setWindowTitle("New program");
    sql = new SQL();

    QWidget *widget = new QWidget();

    vLayout = new QVBoxLayout();

    txtName = new QLineEdit();
    txtName->setPlaceholderText("Name");
    vLayout->addWidget(txtName);

    model = new QStandardItemModel();
    lstExercises = new QListView();
    lstExercises->setModel(model);
    lstExercises->setSelectionMode(QListView::MultiSelection);
    vLayout->addWidget(lstExercises);

    btnSave = new QPushButton("Save");
    connect(btnSave, SIGNAL(clicked()), this, SLOT(saveExercise()));
    vLayout->addWidget(btnSave);

    widget->setLayout(vLayout);
    setCentralWidget(widget);
    load();
}

void NewProgram::load(QString n)
{
    QStringList exercises;
    QModelIndex index;
    QString exercise;
    name = n;
    Program *prog = sql->loadProgram(n);
    txtName->setText(prog->getName());

    exercises = prog->getExerciseNames();
    while(!exercises.isEmpty())
    {
        exercise = exercises.takeFirst();
        for(int i = 0; i < model->rowCount(); i++)
        {
            if(lstExercises->model()->index(i,0).data().toString() == exercise)
            {
                index = model->index(i,0);
                lstExercises->selectionModel()->select(index, QItemSelectionModel::Select);
            }
        }
    }
}

void NewProgram::load()
{
    QStringList list;
    list = sql->getExerciseList();

    if(list.isEmpty())
    {
        model->appendRow(new QStandardItem ("No exercises"));
        lstExercises->setSelectionMode(QListView::NoSelection);
        return;
    }

    while(!list.isEmpty())
    {
        model->appendRow(new QStandardItem(list.takeFirst()));
    }
    model->sort(0);

}


void NewProgram::saveExercise()
{
    QStringList exercises;
    QModelIndexList list;

    QItemSelectionModel *m = lstExercises->selectionModel();
    list = m->selectedRows();
    while(!list.isEmpty())
    {
        exercises.append(list.takeFirst().data().toString());
    }

    if(name == "")
    {
        if(!sql->saveProgram(txtName->text(),exercises))
            qDebug() << "Saving program failed";
    }
    else
    {
        if(!sql->updateProgram(name, txtName->text(),exercises))
            qDebug() << "Update program failed";
    }
    emit closed();
    delete this;
}
