#ifndef INFOWINDOW_H
#define INFOWINDOW_H

#include <QtGui>
#include "sql.h"
#include "exercise.h"
#include "settings.h"
#include "exercisewindow.h"

class InfoWindow : public QMainWindow
{
    Q_OBJECT
public:
    explicit InfoWindow(QWidget *parent = 0);
    void loadExercise(QString name);

private:
    SQL *sql;
    ExerciseWindow *ew;

    QLabel *lblName;
    QLabel *lblMuscle;
    QLabel *lblSet;
    QLabel *lblReps;
    QLabel *lblRest;
    QLabel *lblInfo;
    QLabel *lblLast;

    QPushButton *btnBack;
    QPushButton *btnForward;
    QPushButton *btnStart;

    QString info;
    QString exerciseName;
    QTextEdit *txtInfo;

    QGridLayout *gLayout;
    QGridLayout *gButtonLayout;

    QString weight[9], reps[9], status[9];

private slots:
    void startExercise();
    void forward();
    void back();

};

#endif // INFOWINDOW_H
