#include "infowindow.h"

InfoWindow::InfoWindow(QWidget *parent) :
        QMainWindow(parent)
{
    sql = new SQL();
    QWidget *widget = new QWidget();
    setCentralWidget(widget);

    QVBoxLayout *vLayout = new QVBoxLayout;
    QHBoxLayout *hLabelLayout = new QHBoxLayout;
    gLayout = new QGridLayout();

    lblName = new QLabel("name");
    lblMuscle = new QLabel("muscle");
    lblSet = new QLabel("set");
    lblRest = new QLabel("rest");
    lblLast = new QLabel("last time");
    lblInfo = new QLabel("info on how to do");
    txtInfo = new QTextEdit();
    txtInfo->setReadOnly(true);

    lblInfo->setSizePolicy(QSizePolicy::Expanding,QSizePolicy::Expanding);
    vLayout->addWidget(lblName);
    vLayout->addWidget(lblMuscle);

    hLabelLayout->addWidget(lblSet);
    hLabelLayout->addWidget(lblRest);
    vLayout->addLayout(hLabelLayout);

    vLayout->addWidget(lblLast);

    gLayout->addWidget(txtInfo);
    vLayout->addLayout(gLayout);

    gButtonLayout = new QGridLayout;
    btnBack = new QPushButton("<---");
    btnForward = new QPushButton("--->");

    btnStart = new QPushButton("Start");
    connect(btnStart,SIGNAL(clicked()),this,SLOT(startExercise()));

    gButtonLayout->addWidget(btnBack,0,0);
    gButtonLayout->addWidget(btnForward,0,2);
    gButtonLayout->addWidget(btnStart,0,1);
    vLayout->addLayout(gButtonLayout);


    //vLayout->addWidget(btnStart);

    widget->setLayout(vLayout);
}

void InfoWindow::loadExercise(QString name)
{
    qDebug () << "load exercise 1";
    //QList <QString> list;

    QString min, sec;
    int i = 0;
    QString lastText, tmpLast;

    exerciseName = name;
    if(name == "No exercises")
        return;

    Exercise exercise = sql->loadExercise(exerciseName);

    lblName->setText(exercise.getName());
    lblMuscle->setText(exercise.getMuscles());
    info = exercise.getDescription();

    qDebug () << "load exercise 2";

    Settings settings = sql->loadSettings();

    qDebug () << "load exercise 3";
    sec = QString().setNum(settings.getSec());
    min = QString().setNum(settings.getMin());
    lblRest->setText(min + ":" + sec + " rest");
    qDebug () << "load exercise 5";
    lblSet->setText(QString().setNum(settings.getSet()) + " Set");
    qDebug () << "load exercise 6";
    txtInfo->setText(info);

/*
    list = xml->getHistoryByExercise(exerciseName);

    if(list.isEmpty())
    {
        lblLast->setText("Exercise have never been done.");
        return;
    }

    while(!list.isEmpty())
    {
        weight[i] = list.takeFirst();
        reps[i] = list.takeFirst();
        status[i] = list.takeFirst();

        i++;
    }
    qDebug () << "load exercise 5";
    i = 0;
    lastText = "";
    while(weight[i] != "" && i < 9)
    {
        tmpLast = weight[i];
        tmpLast.remove("kg");
        lastText.append(weight[i] + "x" + reps[i]);
        if(i < 8)
        {
            if(weight[i+1] != "")
                lastText.append(", ");
        }
        qDebug () << "load exercise " << lastText;
        i++;
    }
    qDebug () << "load exercise 6";
    lblLast->setText("Last time: " + lastText);*/

}

void InfoWindow::startExercise()
{
    ew = new ExerciseWindow(this);
    //connect(ew,SIGNAL(closed()),this,SLOT(sendClosed()));
    //connect(ew,SIGNAL(landscape()),this, SLOT(sendLandscape()));
    ew->loadExercise(exerciseName);
    ew->show();
}

void InfoWindow::forward()
{
    /*QString str;
    if(i == 2)
    {
        i = 0;
        gLayout->removeWidget(lblInfo);
        lblInfo->hide();
        gLayout->addWidget(txtInfo);
        txtInfo->show();
        txtInfo->setText(info);
        return;
    }

    else if(i == 1)
    {
        //if(info[2] != "")
        //{
        QPixmap bild(w,h);
        str = "/home/user/.qexercise/Images/" + exerciseName + "2.png";
        str.replace(QString(" "), QString(""));


        if(!bild.load(str))
        {
            i = 2;
            forward();
            return;
        }
        else
        {
            bild = bild.scaled(w,h,Qt::KeepAspectRatio);
            lblInfo->setAlignment(Qt::AlignCenter);
            lblInfo->setPixmap(bild);
            i++;
        }
        //}
        return;
    }

    else if(i == 0)
    {
        //if(info[1] != "")
        //{
        gLayout->removeWidget(txtInfo);
        txtInfo->hide();
        gLayout->addWidget(lblInfo);
        lblInfo->show();
        QPixmap bild(w,h);
        str = "/home/user/.qexercise/Images/" + exerciseName + "1.png";
        str.replace(QString(" "), QString(""));


        if(!bild.load(str))
        {
            i = 1;
            forward();
            return;
        }
        else
        {
            bild = bild.scaled(w,h,Qt::KeepAspectRatio);
            lblInfo->setAlignment(Qt::AlignCenter);
            lblInfo->setPixmap(bild);
            i++;
        }
        //}
        return;
    }*/
}

void InfoWindow::back()
{/*
    QString str;
    if(i == 0)
    {
        //if(info[2] != "")
        //{
        gLayout->removeWidget(txtInfo);
        txtInfo->hide();
        gLayout->addWidget(lblInfo);
        lblInfo->show();
        QPixmap bild(w,h);
        str = "/home/user/.qexercise/Images/" + exerciseName + "2.png";
        str.replace(QString(" "), QString(""));


        if(!bild.load(str))
        {
            i = 2;
            back();
            return;
        }
        else
        {
            bild = bild.scaled(w,h,Qt::KeepAspectRatio);
            lblInfo->setAlignment(Qt::AlignCenter);
            lblInfo->setPixmap(bild);
            i=2;
        }
        //}
        return;
    }
    else if(i == 1)
    {
        gLayout->removeWidget(lblInfo);
        lblInfo->hide();
        gLayout->addWidget(txtInfo);
        txtInfo->show();
        lblInfo->setAlignment(Qt::AlignLeft);
        lblInfo->setAlignment(Qt::AlignTop);
        lblInfo->setText(info);
        i--;
    }
    else if(i == 2)
    {
        //if(info[1] != "")
        //{
        QPixmap bild(w,h);
        str = "/home/user/.qexercise/Images/" + exerciseName + "1.png";
        str.replace(QString(" "), QString(""));

        if(!bild.load(str))
        {
            i = 1;
            back();
            return;
        }
        else
        {
            bild = bild.scaled(w,h,Qt::KeepAspectRatio);
            lblInfo->setAlignment(Qt::AlignCenter);
            lblInfo->setPixmap(bild);
            i--;
        }
        //}
        return;

    }*/
}
