#include "exercisewindow.h"
//#include <mce/dbus-names.h>
//#include <mce/mode-names.h>
//#include <QDBusMessage>
#include <QDebug>



ExerciseWindow::ExerciseWindow(QWidget *parent) :
    QMainWindow(parent)
{
    //setAttribute(Qt::WA_Maemo5StackedWindow);
    qDebug () << "ExerciseWindow::ExerciseWindow 1";
    sql = new SQL();

    QWidget *widget = new QWidget();
    setCentralWidget(widget);
    QVBoxLayout *vLayout = new QVBoxLayout;

    font.setPointSize(22);

    label = new QLabel("");
    label->setAlignment(Qt::AlignCenter);
    label->setFont(font);
    qDebug () << "ExerciseWindow::ExerciseWindow 2";

    btnShake = new QPushButton("Done");

    connect(btnShake,SIGNAL(clicked()),this,SLOT(startCountdown()));

    vLayout->addWidget(label);
    vLayout->addWidget(btnShake);

    qDebug () << "ExerciseWindow::ExerciseWindow 3";
    timer = new QTimer(this);
    qDebug () << "ExerciseWindow::ExerciseWindow 3a";
    QObject::connect(timer,SIGNAL(timeout()),this,SLOT(timerInterrupt()));
    qDebug () << "ExerciseWindow::ExerciseWindow 3b";

    widget->setLayout(vLayout);
    qDebug () << "ExerciseWindow::ExerciseWindow 3c";
}


void ExerciseWindow::loadExercises(Program *program)
{
    qDebug () << "ExerciseWindow::loadExercises 1";
    exercises = program->getExerciseNames();

    openNextExercise();

    font.setPointSize(22);
    label->setFont(font);
    qDebug () << "ExerciseWindow::loadExercises 2";


}

void ExerciseWindow::loadExercise(QString exercise)
{
    qDebug () << "ExerciseWindow::loadExercise 0";
    currentExercise = exercise;
    qDebug() << exercise;

    font.setPointSize(22);
    label->setFont(font);
    label->setText(currentExercise);
    qDebug () << "ExerciseWindow::loadExercise 1";
    Settings settings = sql->loadSettings();
    set = settings.getSet();
    currentSet = 0;
    qDebug () << "ExerciseWindow::loadExercise 2";

}

void ExerciseWindow::loadTimer()
{
    int min,sec;
    Settings settings = sql->loadSettings();
    min = settings.getMin();
    sec = settings.getSec();
    timeLeft = min + sec;
    timer->start(1000);
}

void ExerciseWindow::timerInterrupt()
{
    qDebug () << "ExerciseWindow::timerInterrupt 1";
    if(timeLeft <= 1)
    {
        //time is up!
        timer->stop();
        btnShake->setEnabled(true);
        qDebug () << "ExerciseWindow::timerInterrupt done";

        selectWeight();

    }
    else
    {
        timeLeft--;
        qDebug () << "ExerciseWindow::timerInterrupt counting";
    }
}

void ExerciseWindow::nextSet()
{
    currentSet++;
    if(set == currentSet)
    {
        qDebug() << "Exercise done";

        if(!openNextExercise())
        {
            btnShake->setEnabled(false);
            qDebug() << "Everythings done";
        }

    }
}

bool ExerciseWindow::openNextExercise()
{
    exercises.removeOne(currentExercise);
    if (exercises.isEmpty())
        return false;
    else
    {
        se = new SelectExercise();
        connect(se,SIGNAL(exerciseName(QString)),this,SLOT(loadExercise(QString)));
        se->load(exercises);

        se->show();
        return true;
    }

}

void ExerciseWindow::shaked()
{
    //phone is shaked
}

void ExerciseWindow::startCountdown()
{
    loadTimer();
    btnShake->setEnabled(false);
    //edit the label
}

void ExerciseWindow::selectWeight()
{
    sw = new SelectWeight(this);
    qDebug() << currentExercise;

    sw->load(currentExercise,currentSet);
    connect(sw,SIGNAL(next()),this,SLOT(nextSet()));
    sw->show();
}
