#include "exercisesettings.h"

ExerciseSettings::ExerciseSettings(QWidget *parent) :
    QDialog(parent)
{
    sql = new SQL();
    setWindowTitle("Exercise settings");

    QVBoxLayout *vLayout = new QVBoxLayout;
    cmbSet = new QComboBox();
    vLayout->addWidget(cmbSet);

    for(int i = 1; i < 10; i++)
        cmbSet->addItem(QString().setNum(i));

    cmbMin = new QComboBox();
    for(int i = 0; i < 10; i++)
        cmbMin->addItem(QString().setNum(i));

    vLayout->addWidget(cmbMin);

    cmbSec = new QComboBox();
    for(int i = 0; i < 12; i++)
        cmbSec->addItem(QString().setNum(i*5));
    vLayout->addWidget(cmbSec);

    setLayout(vLayout);
    load();
}

void ExerciseSettings::closeEvent(QCloseEvent *event)
{
    save();
}

void ExerciseSettings::save()
{
    if(!sql->saveExerciseSettings(cmbSet->currentText().toInt(),
                                  cmbMin->currentText().toInt(),
                                  cmbSec->currentText().toInt()))
    {
        qDebug() << "Saving settings failed";
    }
}

void ExerciseSettings::load()
{
    Settings settings = sql->loadSettings();
    cmbSet->setCurrentIndex(cmbSet->findText(QString().setNum(settings.getSet())));
    cmbMin->setCurrentIndex(cmbMin->findText(QString().setNum(settings.getMin())));
    cmbSec->setCurrentIndex(cmbSec->findText(QString().setNum(settings.getSec())));

}
