#include "dayhistory.h"

DayHistory::DayHistory(QWidget *parent) :
    QMainWindow(parent)
{
    sql = new SQL();
    model = new QStandardItemModel(this);

    lstHistory = new QListView();
    lstHistory->setModel(model);

    //lstExercises->setContextMenuPolicy(Qt::CustomContextMenu);
    //connect(lstExercises, SIGNAL(customContextMenuRequested(const QPoint &)),SLOT(showContextMenuForWidget(const QPoint &)));

    setCentralWidget(lstHistory);
}

void DayHistory::loadHistory(QString date)
{
    QList<ExerciseHistory> history;
    history = sql->loadExerciseHistoryByDate(QDate().fromString(date,"ddMMyyyy"));

    while(!history.isEmpty())
    {
        model->appendRow(new QStandardItem(history.takeFirst().getName()));
    }
}
