#!/usr/bin/env python
#-*- coding: utf-8 -*-

#Copyleft (Ɔ) 2011: Code is released under the conditions of the GNU General Public License Version 3.
#Author: Gabriel Böhme
#E-Mail: m.gabriel.boehme@googlemail.com
#Thanks: Boris Pohler boris@pohlers-web.de aka "Cermit" on German MeeGo.de Forum ;)

#Importe
import sys
from functools import partial
from PyQt4.QtCore import Qt, QString
from PyQt4.QtGui import QApplication, QMainWindow, QMessageBox, QLabel, QFont
from PyQt4.QtMaemo5 import QMaemo5InformationBox
from PyQt4.uic import loadUi

#--------------------------------------------------------------------------------------------------

#Klasse für das Hauptfenster
class calcWindow(QMainWindow):
	#Variable zur Prüfung ob erster Start/Erste Zahl eingegeben wird. :(
	first = True

	def __init__(self):
		QMainWindow.__init__(self)	
		self.ui = loadUi("meecalc_maemo.ui")
		self.ui.show()
		self.ui.setAttribute(Qt.WA_Maemo5PortraitOrientation, True)
		self.ui.action_ueber.triggered.connect(self.zeige_ueber)
		self.ui.action_beenden.triggered.connect(self.beenden)

#--------------------------------------------------------------------------------------------------
	#connections für zahlen und reset: über button_pressed() Funktion
		self.ui.no0.clicked.connect(self.button_pressed)
        	self.ui.no1.clicked.connect(self.button_pressed)
       	 	self.ui.no2.clicked.connect(self.button_pressed)
        	self.ui.no3.clicked.connect(self.button_pressed)
        	self.ui.no4.clicked.connect(self.button_pressed)
        	self.ui.no5.clicked.connect(self.button_pressed)
        	self.ui.no6.clicked.connect(self.button_pressed)
        	self.ui.no7.clicked.connect(self.button_pressed)
        	self.ui.no8.clicked.connect(self.button_pressed)
        	self.ui.no9.clicked.connect(self.button_pressed)
		self.ui.reset.clicked.connect(self.button_pressed)

	# connection für punkt button_pressed_dot() Funktion
		self.ui.komma.clicked.connect(self.button_pressed)
		
	# +/- Rechnung, da +/- keine Sonderzeichen sind über die button_pressed Funktion
		self.ui.plus.clicked.connect(self.button_pressed)
		self.ui.minus.clicked.connect(self.button_pressed)
		
	#connections für Rechenoperationen: x, ÷, ± (extra wegen sonderzeichen)
		self.ui.vorzeichenwechsel.clicked.connect(partial(self.button_extra_operation,'vorzeichen')) #zu ergänzen
		self.ui.mal.clicked.connect(partial(self.button_extra_operation,'mal'))
		self.ui.durch.clicked.connect(partial(self.button_extra_operation,'durch'))
		
	#V #connection für Backspace-Taste (wegen Icon nicht mit button_pressed realisiert)
		self.ui.back.clicked.connect(self.button_backspace)

	#connection für Ergebnis-Rechnung: über ergebnis() Funktion
		self.ui.gleich.clicked.connect(self.button_ergebnis)

#--------------------------------------------------------------------------------------------------
	#Funktion zur Prüfung und Anpassung der Schriftgröße für das Ergebnis.
	def LineEdit_font_sizer(self, l):
		font = QFont()
		
		if len(l) < 5:
			font.setPointSize(90)	
		if len(l) >= 5 and len(l) < 10:
			font.setPointSize(45)
		if len(l) >= 10 and len(l) < 15:
			font.setPointSize(30)
		if len(l) >= 15 and len(l) < 19:
			font.setPointSize(24)
			
		self.ui.line.setFont(font)

#--------------------------------------------------------------------------------------------------
	#Funktion für gelben Maemo5 Banner, bei Aufruf ist das Argument 'warnung' zu übergeben!
	def zeichen_max_warn(self, warnung):
		QMaemo5InformationBox.information(None, QString(warnung), 2500)
		
#--------------------------------------------------------------------------------------------------

	#Darstellung der Zahlen 1-9 sowie . + - im LineEdit, bzw. Reset der kompletten Leiste 
	def button_pressed(self):
			#button_text wird "gelesen" und entspricht der Beschriftung aus UI/QtDesigner File
        		button_text = str(self.sender().text())
			
			#Wenn es die erste Eingabe der Zahlen 1-9 is dann wird LineEdit gelöscht und die Zahl gesetzt
        		if button_text in ('0123456789'):
				if calcWindow.first == True:
					self.ui.line.setText("")
					self.ui.line.setText(button_text)
					calcWindow.first = False
					return calcWindow.first

			#Wenn es NICHT die erste Eingabe ist, dann wird die übrige Line genommen und die neue Zahl angefügt.
				if calcWindow.first == False:
					if len(self.ui.line.text()) >= 19:
						warnung = "Achtung Eingabe ist zu lang!"
						self.zeichen_max_warn(warnung)
					else:					
						self.ui.line.setText(self.ui.line.text()+button_text)
						l = self.ui.line.text()
						l = l.replace('x', '*')
						l = l.replace(u'÷', '/')
						l = str(l)
						self.LineEdit_font_sizer(l)
			
			#Umgang mit Operationszeichen		
			if button_text in ('.-+'):
				#Wenn Erste Eingabe/neue Rechnung und Ergebnis != 0 wird das Operationszeichen angehängt.
				if calcWindow.first == True and self.ui.line.text() != '0':
					if len(self.ui.line.text()) >= 19:
						warnung = "Achtung Eingabe ist zu lang!"
						self.zeichen_max_warn(warnung)
					else:			
						self.ui.line.setText(self.ui.line.text()+button_text)
						l = str(self.ui.line.text())
						self.LineEdit_font_sizer(l)
						calcWindow.first = False
						return calcWindow.first

				#Wenn neue Rechnung (nach =), dann wird 0 aus LineEdit mit Operationszeichen (+-) ersetzt.
				if calcWindow.first == True and self.ui.line.text() == '0':
					self.ui.line.setText("")					
					self.ui.line.setText(button_text)
					l = str(self.ui.line.text())
					self.LineEdit_font_sizer(l)					
					calcWindow.first = False
					return calcWindow.first
				
				#Falls es schon auf False steht wird nur angehängt, wie bei den Zahlen.
				if calcWindow.first == False:
					if len(self.ui.line.text()) >= 19:
						warnung = "Achtung Eingabe ist zu lang!"
						self.zeichen_max_warn(warnung)
					else:
						self.ui.line.setText(self.ui.line.text()+button_text)
						l = str(self.ui.line.text())
						self.LineEdit_font_sizer(l)			

			#Wird "C" gedrückt wird die bisherige Eingabe gelöscht.
			if button_text == 'C':
				self.ui.line.setText('0')
				calcWindow.first = True
				l = str(self.ui.line.text())
				self.LineEdit_font_sizer(l)
				return calcWindow.first

#--------------------------------------------------------------------------------------------------

	#Löschtaste, extra implementiert, weil die Darstellung mit Icon und nicht mit Text des Buttons erfolgt.
	def button_backspace(self):
		self.ui.line.backspace()
		l = str(self.ui.line.text())
		self.LineEdit_font_sizer(l)

#--------------------------------------------------------------------------------------------------

	#Nur zur Darstellung der Sonderzeichen auf LineEdit, bzw. zum Vorzeichenwechsel.
	def button_extra_operation(self, sonderzeichen):
        	if sonderzeichen == 'mal':
			if len(self.ui.line.text()) >= 19:
				warnung = "Achtung Eingabe ist zu lang!"
				self.zeichen_max_warn(warnung)
			else:	
				self.ui.line.setText(self.ui.line.text()+u'x')
				l = self.ui.line.text()
				l = l.replace('x', '*')
				l = str(l)
				self.LineEdit_font_sizer(l)
			calcWindow.first = False
			return calcWindow.first


		if sonderzeichen == 'durch':
			if len(self.ui.line.text()) >= 19:
				warnung = "Achtung Eingabe ist zu lang!"
				self.zeichen_max_warn(warnung)
			else:	
				self.ui.line.setText(self.ui.line.text()+u'÷')
				l = self.ui.line.text()
				l = l.replace(u'÷', '/')
				l = str(l)
				self.LineEdit_font_sizer(l)					
			calcWindow.first = False	
			return calcWindow.first
		
		if sonderzeichen == 'vorzeichen': #Funktion noch nicht implementiert!
			print 'SONDERZEICHEN: ±!'

#--------------------------------------------------------------------------------------------------

	#Berechnung des Ergebnis auf Basis der Eingabe im LineEdit
	def button_ergebnis(self):
		calc_line = self.ui.line.text()
		self.ui.line.setText("")
		
		#Hier werden die "÷" und "x" Zeichen (UTF-8) mit "*" und "/" ersetzt -> eval() verlangt ASCII Zeichen
		calc_line = calc_line.replace('x', '*')
		calc_line = calc_line.replace(u'÷', '/')
		
		#Division verlangt mindestens einen Float Wert, daher spliten an den Brüchen und dann Multiplikation mit 1.0 mit 1. Wert
		if '/' in str(calc_line):
			# Splitung der Eingabe bei / und 1. Stelle multipliziert mit 1.0 für Float
			splited = calc_line.split('/')
			calc_line = splited[0]
			for i in range(1, len(splited)):
				calc_line = calc_line + "*1.0/" + splited[i]
			
		calc_line = str(calc_line)	
		ergebnis = eval(calc_line)
		ergebnis = str(ergebnis) #Da eval() einen int-Type erzeugt - Umwandlung in str für QLineEdit	
		
		#Kontrolle der Ergebnislänge und anpassen der Schriftgröße.
		self.LineEdit_font_sizer(ergebnis)
		
		#Ergebnis wird auf LineEdit geschrieben, falls es zu lang ist erscheint ein gelber Maemo5 Banner mit Hinweis auf Überlänge.
		if len(ergebnis) >= 18:
			warnung = "Das Ergebnis ist zu lang!"
			self.zeichen_max_warn(warnung)
			ergebnis = '-'
		self.ui.line.setText(ergebnis)
		
		#Eingabe wird wieder auf "Erste" gesetzt damit ggf. weitergerechnet oder LineEdit gelöscht werden kann.
		calcWindow.first = True
		return calcWindow.first
		
		

#--------------------------------------------------------------------------------------------------
	
#Funktion(en) für Menü-Einträge:
	
	#Menü - Über: Text
	def zeige_ueber(self):
        	QMessageBox.about(self, 
                          u"Über diese App",u"""<b>MeeCalc</b>
                          <p>Diese kleine App ist als ganz einfacher Ersatz des Standard Maemo
				Taschenrechners gedacht, dabei ist er optisch an den Rechner des 
				Nokia N9 mit MeeGo Harmattan angelehnt.
				<p>Der Quellcode steht unter GPL Version 3.""")

	#Menü - Beenden: Beendet MeeCalc (später vielleicht mit Nachfrage Box) ;)
	def beenden(self):
		exit(self)
	
#--------------------------------------------------------------------------------------------------

#Starten des Programms:
if __name__ == "__main__":
	#Qt Umgebung
	app = QApplication(sys.argv)
	#Objekt (Fenster) wird aus Klasse geschaffen
	fenster = calcWindow()
	#START
	sys.exit(app.exec_())


