# -*- coding: utf-8 -*-
'''
MediaBox Widget UI Widget
2010(c) Kirill Plyashkevich <ru.spirit@gmail.com>
'''

import gobject, gtk
from advpowcommon.ui.Cachers import PixbufFileCacher
from mediabox_widget.ui.Cairo import Cairo
from mediabox_widget.ui.Theme import *

class Widget(gtk.DrawingArea):

  __gsignals__ = {'expose-event': 'override'}
  cacher = PixbufFileCacher()
  _theme = get_theme()

  DISABLED = 0
  ENABLED = 1
  PRESSED = 2

  def __init__(self, name='', size=[-1, -1]):
    gtk.DrawingArea.__init__(self)
    self.set_name(name)
    self.inforeground = True
    self.has_alpha = False
    self.size_width, self.size_height = size
    self.set_events(gtk.gdk.VISIBILITY_NOTIFY_MASK)
    self.set_size_request(self.size_width, self.size_height)
    self.modify_bg(gtk.STATE_NORMAL, gtk.gdk.color_parse(self._theme.get_color('mb_background')))
    self.__wstate = self.ENABLED
    self.__redrawing = False
    self.active = True
    self.connect('visibility-notify-event', self.__do_visible_notify_event)

  def __do_visible_notify_event(self, widget, event):
    self.handle_visible(self.get_property('visible'))

  def set_active(self, flag):
    self.active = flag
    self.redraw(flag)

  def handle_visible(self, flag):
    pass

  def get_wstate(self):
    return self.__wstate

  def enable(self):
    self.__wstate = self.ENABLED
    self.set_property('sensitive', True)
    self.redraw()

  def disable(self):
    self.__wstate = self.DISABLED
    self.set_property('sensitive', False)
    self.redraw()

  def press(self):
    if self.__wstate == self.ENABLED:
      self.__wstate = self.PRESSED
      self.redraw(True)

  def get_available_states(self):
    return (self.DISABLED, self.ENABLED, self.PRESSED)

  def redraw(self, force=False):
    try:
      if force:
        gobject.idle_add(self.do_expose_event, None)
      else:
        if self.active:
          if not self.__redrawing:
            self.queue_draw_area(0, 0, self.allocation[2], self.allocation[3])#self.size_width, self.size_height)
            self.__redrawing = True
    except:
      pass

  def draw(self, cr):
    raise NotImplementedError('AbstractWidget.draw() must be implemented')

  def do_expose_event(self, event):
    try:
      cr = Cairo.draw_rectangle(self, self._theme.get_color('mb_background'), self.has_alpha, self._theme.get_alpha())
      if cr:
        self.draw(cr)
        self.__redrawing = False
    except:
      pass
    return None

  def do_screen_changed(self, new_screen=None):
    try:
      screen = self.get_screen()
      colormap = screen.get_rgba_colormap()
      if colormap:
        self.has_alpha = True
      else:
        colormap = screen.get_rgb_colormap()
        self.has_alpha = False
      self.set_colormap(colormap)
    except:
      pass
    return None

  def do_realize(self):
    self.do_screen_changed()
    gtk.DrawingArea.do_realize(self)
    return None

class ImageWidget(Widget):

  def __init__(self, name='', size=[-1, -1], images=('', '', '')):
    Widget.__init__(self, name, size)
    self.images = {}
    self.__images_files = images
    self.__load_images()

  def set_images(self, images):
    self.__images_files = images
    self.__load_images()
    self.redraw(True)

  def __load_images(self):
    self.images = dict(zip(self.get_available_states(), map(self.load_image, map(self._theme.get_image, self.__images_files))))

  def load_image(self, file):
    raise NotImplementedError('ImageWidget.load_image() must be implemented')
