# -*- coding: utf-8 -*-
'''
MediaBox Widget UI Image
2010(c) Kirill Plyashkevich <ru.spirit@gmail.com>
'''

import gtk
from mediabox_widget.ui.Widgets import ImageWidget
from mediabox_widget.ui.Cairo import Cairo

class Image(ImageWidget):

  def __init__(self, image, name, size):
    ImageWidget.__init__(self, name, size, (image,))

  def get_available_states(self):
    return (self.ENABLED,)

  def draw(self, cr):
    image = self.images[self.ENABLED]
    if image:
      Cairo.draw_add_pixbuf(cr, image, (self.allocation[2] - image.get_width())/2, (self.allocation[3] - image.get_height())/2)
    return False

  def load_image(self, image):
    pix = self.cacher.get(image)
    if self.size_width != -1 or self.size_height != -1:
      iw, ih = self.size_width, self.size_height
      if iw == -1:
        iw = int((float(pix.get_width())/pix.get_height())*self.size_height)
      if ih == -1:
        ih = int((float(pix.get_height())/pix.get_width())*self.size_width)
      pix = pix.scale_simple(iw, ih, gtk.gdk.INTERP_BILINEAR)
    return pix
