# -*- coding: utf-8 -*-
'''
MediaBox Widget
2010(c) Kirill Plyashkevich <ru.spirit@gmail.com>
Connects to bunch of dbus signals and controls player.
'''
import gobject, gtk, hildon

import dbus
from dbus.mainloop.glib import DBusGMainLoop

from advpowcommon.util.execn import *
from mediabox_widget.ui.Buttons import Button, ImageButton
from mediabox_widget.ui.Cairo import Cairo
from mediabox_widget.ui.ConfirmDialog import ConfirmDialog
from mediabox_widget.ui.Image import Image
from mediabox_widget.ui.ProgressBar import HProgressBar, SeekBar
from mediabox_widget.ui.ScrollingText import ScrollingText
from mediabox_widget.ui.Theme import *
from mediabox_widget.util.config import *

class AbstractMediaBoxWidget():

  app_name = 'MediaBox Home Widget'
  version = '0.4.2'
  dev_author = 'Kirill Plyashkevich'
  dev_email = 'ru.spirit@gmail.com'
  dev_years = '2010'
  mediabox_root = 'de.pycage.mediabox'
  mediabox_path = '/de/pycage/mediabox/control'
  mediabox_iface = 'de.pycage.mediabox.control'
  corner_radius = 10
  control_spacing = 6
  debug = False

  def __init__(self):
    self.__super_init__()

    def _name_owner_handler(name, old, new):
      if str(name) == self.mediabox_root:
        if str(new):
          self.__control = dbus.Interface(self.__bus.get_object(self.mediabox_root, self.mediabox_path), self.mediabox_iface)
        else:
          self.__control = None
        self.connection_updated()

    self._config = get_config()
    self._mb_config = get_mediabox_config()
    self.__config_controls = {}
    self._theme = get_theme()
    self.__mediabox_state = 'unknown'
    self.__has_alpha = False
    self.__inforeground = False
    self.__control = None
    self.track = {'artist': '-', 'title': '-', 'album': '-'}
    self.__bus = dbus.SessionBus(mainloop = DBusGMainLoop(), private = True)
    self.__info_banner = None
    self.start_command = 'run-standalone.sh MediaBox'

    #checking for running MediaBox, so it won't be loaded at widget startup
    mediabox_loaded = get_shell_command_output('ps aux | grep \'MediaBox\' | grep -v \'grep\' | awk {\'print $3\'}')
    if mediabox_loaded:
      try:
        self.__control = dbus.Interface(self.__bus.get_object(self.mediabox_root, self.mediabox_path), self.mediabox_iface)
      except Exception, e:
        self.__control = None
        print e

    self.__signals = {'NameOwnerChanged': {'cb':_name_owner_handler, 'signal_name': 'NameOwnerChanged', 'dbus_interface': 'org.freedesktop.DBus', 'path': '/org/freedesktop/DBus'},
                      'StateSignal': {'cb': self.state_changed, 'signal_name': 'state_signal', 'dbus_interface': self.mediabox_iface, 'path': self.mediabox_path},
                      'SeekSignal': {'cb': self.seek_changed, 'signal_name': 'seek_signal', 'dbus_interface': self.mediabox_iface, 'path': self.mediabox_path},
                      'LoadSignal': {'cb': self.load_changed, 'signal_name': 'load_signal', 'dbus_interface': self.mediabox_iface, 'path': self.mediabox_path},
                      'TagSignal': {'cb': self.tag_changed, 'signal_name': 'tag_signal', 'dbus_interface': self.mediabox_iface, 'path': self.mediabox_path}
                     }
    self.__init_signals()
    self.__compact_view = self._config.get_value('compact-layout')
    self.__watch_widgets = set()
    if self.__compact_view:
      self.create_compact_view()
    else:
      self.create_view()
    self.__working = True
    self.connect('destroy', self.__cleanup)
    self.__custom_init__()
    self.connection_updated()
    #self.show_settings_dialog()

  def show_settings_dialog(self, widget=None):
    settings_dialog = cdialog = gtk.Dialog('%s Settings' % (self.app_name), None, gtk.DIALOG_MODAL | gtk.DIALOG_NO_SEPARATOR, self.settings_dialog_buttons)
    vbox = gtk.VBox()
    pa = hildon.PannableArea()
    pa.add_with_viewport(vbox)

    self._config.load()
    self.__config_controls.clear()
    config_keys = self._config.get_keys()
    config_keys.sort()
    for config_key in config_keys:
      name, ck_type, value = self._config.get_entry(config_key)
      if ck_type == type(None):
        continue
      elif ck_type == bool:
        config_control = hildon.CheckButton(gtk.HILDON_SIZE_HALFSCREEN_WIDTH | gtk.HILDON_SIZE_FINGER_HEIGHT)
        config_control.set_label(config_key)
        config_control.set_active(value)
      elif ck_type == list:
        config_control = hildon.PickerButton(gtk.HILDON_SIZE_HALFSCREEN_WIDTH | gtk.HILDON_SIZE_FINGER_HEIGHT, hildon.BUTTON_ARRANGEMENT_VERTICAL)
        config_control.set_title(config_key)
        config_control.set_alignment(0, 0.5, 0, 0)
        config_control.set_value('%s' % (value))
      elif ck_type == tuple:
        config_control = hildon.PickerButton(gtk.HILDON_SIZE_HALFSCREEN_WIDTH | gtk.HILDON_SIZE_FINGER_HEIGHT, hildon.BUTTON_ARRANGEMENT_VERTICAL)
      elif ck_type == dict:
        config_control = hildon.PickerButton(gtk.HILDON_SIZE_HALFSCREEN_WIDTH | gtk.HILDON_SIZE_FINGER_HEIGHT, hildon.BUTTON_ARRANGEMENT_VERTICAL)
      else:
        config_control = hildon.PickerButton(gtk.HILDON_SIZE_HALFSCREEN_WIDTH | gtk.HILDON_SIZE_FINGER_HEIGHT, hildon.BUTTON_ARRANGEMENT_VERTICAL)#HORIZONTAL)
        config_control.set_title(config_key)
        config_control.set_alignment(0, 0.5, 0, 0)
        config_ts = hildon.TouchSelector()
        config_control.set_selector(config_ts)
        config_list_store = gtk.ListStore(str, ck_type)
        config_options = self._config.get_option(config_key)
        config_ts.append_text_column(config_list_store, True)
        config_ts.set_column_selection_mode(hildon.TOUCH_SELECTOR_SELECTION_MODE_SINGLE)
        if config_options:
          for config_option in config_options:
            config_list_store.append([str(config_option), config_option])
          config_control.set_active(config_options.index(value))
        else:
          config_list_store.append([str(value), value])
          config_control.set_active(0)
      self.__config_controls[config_key] = config_control
      vbox.add(config_control)
    settings_dialog.vbox.add(pa)
    settings_dialog.vbox.set_size_request(-1, min(350, len(config_keys)*70))
    settings_dialog.show_all()
    response = settings_dialog.run()
    if response == gtk.RESPONSE_OK:
      self.save_settings()
    settings_dialog.destroy()

  def save_settings(self):
    config_keys = self._config.get_keys()
    for config_key in config_keys:
      name, ck_type, value = self._config.get_entry(config_key)
      if ck_type == bool:
        value = self.__config_controls[config_key].get_active()
      elif ck_type == list:
        pass
      else:
        ts = self.__config_controls[config_key].get_selector()
        model = ts.get_model(0)
        citer = model.get_iter_first()
        ts.get_selected(0, citer)
        value = ck_type(model.get_value(citer, 1))
      self._config.set_value(config_key, value)
    self._config.save()

  def create_view(self):
    self.size_width = 434
    self.size_height = 216
    self.start_button = Button('start_mediabox', [self.size_width/2, 64], icon='logo', text='', action=self.start_mediabox)
    self.start_box = gtk.Table(3, 3)
    self.start_box.attach(self.create_label(''), 0, 1, 0, 3, gtk.EXPAND, gtk.EXPAND)
    self.start_box.attach(self.create_label(''), 0, 1, 0, 1, gtk.EXPAND, gtk.EXPAND)
    self.start_box.attach(self.start_button, 1, 2, 1, 2, gtk.SHRINK, gtk.SHRINK)
    self.start_box.attach(self.create_label(''), 2, 3, 2, 3, gtk.EXPAND, gtk.EXPAND)
    self.start_box.attach(self.create_label(''), 2, 3, 0, 3, gtk.EXPAND, gtk.EXPAND)
    self.track_image = Image('logo', 'track_image', [160, -1])
    self.track_artist = ScrollingText('track_artist', [192, 32], '', 20)
    self.track_title = ScrollingText('track_title', [192, 32], '', 20)
    self.track_album = ScrollingText('track_album', [192, 32], '', 20)
    self.seek_control = SeekBar('seekbar', [352, 32], self.seek)
#    self.volume_control = HClickableProgressBar('volumebar', [352, 32], self.set_volume)
    info_box = gtk.Table(4, 2)
    info_box.attach(self.track_image, 0, 1, 0, 3, gtk.SHRINK, gtk.EXPAND | gtk.FILL)
    info_box.attach(self.track_artist, 1, 2, 0, 1, gtk.SHRINK, gtk.EXPAND)
    info_box.attach(self.track_title, 1, 2, 1, 2, gtk.SHRINK, gtk.EXPAND)
    info_box.attach(self.track_album, 1, 2, 2, 3, gtk.SHRINK, gtk.EXPAND)
    info_box.attach(self.seek_control, 0, 2, 3, 4, gtk.SHRINK, gtk.SHRINK)
#    self.play_button = Button('play', [64, 64], icon='btn_play_1', action=self.play)
#    self.pause_button = Button('pause', [64, 64], icon='btn_pause_1', action=self.pause)
#    self.prev_button = Button('prev', [64, 64], icon='btn_previous_1', action=self.prev)
#    self.next_button = Button('next', [64, 64], icon='btn_next_1', action=self.next)
    self.play_button = ImageButton(('cursor_frame', 'btn_play_1', 'btn_play_2'), 'play_button', [64, 64], self.play)
    self.pause_button = ImageButton(('cursor_frame', 'btn_pause_1', 'btn_pause_2'), 'pause_button', [64, 64], self.pause)
    self.prev_button = ImageButton(('cursor_frame', 'btn_previous_1', 'btn_previous_2'), 'prev_button', [64, 64], self.prev)
    self.next_button = ImageButton(('cursor_frame', 'btn_next_1', 'btn_next_2'), 'next_button', [64, 64], self.next)
    buttons_box = gtk.VBox(homogeneous=True, spacing=self.control_spacing)
    buttons_box.pack_start(self.prev_button, expand=False, fill=False)
    buttons_box.pack_start(self.play_button, expand=False, fill=False)
    buttons_box.pack_start(self.pause_button, expand=False, fill=False)
    buttons_box.pack_start(self.next_button, expand=False, fill=False)
    self.screen_box = gtk.HBox(spacing=self.control_spacing)
    self.screen_box.pack_start(info_box)
    self.screen_box.pack_start(buttons_box)
    self.widget_box = gtk.VBox(homogeneous=True, spacing=self.control_spacing)
    self.widget_box.pack_start(self.screen_box)
    self.widget_box.pack_start(self.start_box, expand=False, fill=False)
    self.widget_box.set_border_width(self.control_spacing)
    self.add(self.widget_box)
    self.set_size_request(self.size_width, self.size_height)
    self.__watch_widgets = (self.track_image, self.track_artist, self.track_title, self.track_album, self.seek_control)

  def create_compact_view(self):
    self.size_width = 340
    self.size_height = 86
    self.start_button = Button('start_mediabox', [self.size_width - 3*self.control_spacing, 64], icon='logo', text='', action=self.start_mediabox)
    self.start_box = gtk.Table(3, 3)
    self.start_box.attach(self.create_label(''), 0, 1, 0, 3, gtk.EXPAND, gtk.EXPAND)
    self.start_box.attach(self.create_label(''), 0, 1, 0, 1, gtk.EXPAND, gtk.EXPAND)
    self.start_box.attach(self.start_button, 1, 2, 1, 2, gtk.SHRINK, gtk.SHRINK)
    self.start_box.attach(self.create_label(''), 2, 3, 2, 3, gtk.EXPAND, gtk.EXPAND)
    self.start_box.attach(self.create_label(''), 2, 3, 0, 3, gtk.EXPAND, gtk.EXPAND)
    self.screen_box = gtk.VBox(spacing=self.control_spacing)
    buttons_box = gtk.HBox(homogeneous=True, spacing=self.control_spacing)
    info_box = gtk.HBox(spacing=self.control_spacing)
    self.seek_control = SeekBar('seekbar', [96, 32], self.seek)
    self.seek_control.set_active(False)
    button_width = (self.size_width - 4*self.control_spacing)/3
    self.play_button = Button('play', [button_width, 32], icon='btn_play_1', action=self.play)
    self.pause_button = Button('pause', [button_width, 32], icon='btn_pause_1', action=self.pause)
    self.prev_button = Button('prev', [button_width, 32], icon='btn_previous_1', action=self.prev)
    self.next_button = Button('next', [button_width, 32], icon='btn_next_1', action=self.next)
#    self.play_button = ImageButton(('cursor_frame', 'btn_play_1', 'btn_play_2'), 'play_button', [48, 48], self.play)
#    self.pause_button = ImageButton(('cursor_frame', 'btn_pause_1', 'btn_pause_2'), 'pause_button', [48, 48], self.pause)
#    self.prev_button = ImageButton(('cursor_frame', 'btn_previous_1', 'btn_previous_2'), 'prev_button', [48, 48], self.prev)
#    self.next_button = ImageButton(('cursor_frame', 'btn_next_1', 'btn_next_2'), 'next_button', [48, 48], self.next)
    self.track_text = ScrollingText('track_title', [286, 36], '', 20)
    self.track_image = Image('logo', 'track_image', [36, -1])
    info_box.pack_start(self.track_image)
    info_box.pack_start(self.track_text)
    self.screen_box.pack_start(info_box)
    #buttons_box.pack_start(self.seek_control)
    buttons_box.pack_start(self.prev_button)
    buttons_box.pack_start(self.play_button)
    buttons_box.pack_start(self.pause_button)
    buttons_box.pack_start(self.next_button)
    self.screen_box.pack_start(buttons_box)
    self.widget_box = gtk.VBox(homogeneous=True, spacing=self.control_spacing)
    self.widget_box.pack_start(self.screen_box)
    self.widget_box.pack_start(self.start_box, expand=False, fill=False)
    self.widget_box.set_border_width(self.control_spacing)
    self.add(self.widget_box)
    self.set_size_request(self.size_width, self.size_height)
    self.__watch_widgets = (self.track_text,)

  def __super_init__(self):
    raise NotImplementedError('AbstractMediaBoxWidget.__super_init__() must be implemented')

  def __custom_init__(self):
    raise NotImplementedError('AbstractMediaBoxWidget.__custom_init__() must be implemented')

  def __init_signals(self):
    for key in self.__signals:
      self.__signals[key]['receiver_match'] = self.__bus.add_signal_receiver(self.__signals[key]['cb'], signal_name=self.__signals[key]['signal_name'], dbus_interface=self.__signals[key]['dbus_interface'], path=self.__signals[key]['path'])

  def __cleanup(self, widget=None):
    self.seek_control.stop_timer()
    self.__working = False
    for key in self.__signals:
      self.__bus._clean_up_signal_match(self.__signals[key]['receiver_match'])
      self.__bus.remove_signal_receiver(self.__signals[key]['receiver_match'])
      self.__signals[key]['receiver_match'].remove()
    self.destroy()

  def connection_updated(self):
    if self.__control:
      self.start_button.disable()
      self.start_box.hide()
      self.screen_box.show_all()
      self.set_track_info(self.app_name, self.version, '')
      self.update_track_info()
      self.track_image.set_images(('logo',))
      self.seek_control.hide()
#      self.volume_control.update_progress(self.get_volume(), 100)
    else:
      self.start_button.enable()
      self.start_box.show()
      self.screen_box.hide()
      self.clear_track_info()
    self.pause_button.hide()
    self.set_size_request(self.size_width, self.size_height)

#Misc
  def start_mediabox(self, widget=None):
    def start_mb():
      run_shell_command_async(self.start_command, self.__info_banner)
    if self._config.get_value('confirm-start-mediabox'):
      ConfirmDialog.show_confirm('MediaBox Home Widget', 'Start MediaBox?', start_mb)
    else:
      start_mb()

#Signals
  def state_changed(self, state):
    state = str(state)
    try:
      getattr(self, 'handle_%s' % (state))()
      self.__mediabox_state = state
    except:
      print 'Unknown state: %s' % (state)

  def seek_changed(self, pos, total):
    self.seek_control.update_progress(pos/1000, total/1000)
#    self.seek_control.start_timer()

  def load_changed(self, name, info, file, mimetype):
    self.seek_control.show()
    self.seek_control.update_progress(0, 0)
    info = info.replace(' file', '')
    if mimetype.startswith('audio'):
      self.track_image.set_images(('folder_music_album',))
    elif mimetype.startswith('video'):
      self.track_image.set_images(('folder_video',))
      self.set_track_info(name, info, '')
      self.update_track_info()
    elif mimetype.startswith('image'):
      self.track_image.set_images(('folder_image',))
      self.set_track_info(name, info, '')
      self.update_track_info()

  def clear_track_info(self):
    self.set_track_info('-', '-', '-')
    self.update_track_info()
    self.seek_control.update_progress(0, 0)

  def update_track_info(self):
    if self.__compact_view:
      if self.track['artist'] != '-':
        self.track_text.set_text('%s - %s' % (self.track['artist'], self.track['title']))
      else:
        self.track_text.set_text('%s' % (self.track['title']))
    else:
      self.track_artist.set_text(self.track['artist'])
      self.track_title.set_text(self.track['title'])
      self.track_album.set_text(self.track['album'])

  def set_track_info(self, artist, title, album):
    self.track['artist'] = artist
    self.track['title'] = title
    self.track['album'] = album

  def tag_changed(self, key, value):
    self.track[key.lower()] = str(value)
    self.update_track_info()

  def handle_playing(self):
    self.seek_control.start_timer()
    self.pause_button.show()
    self.play_button.hide()
    self.play_button.enable()

  def handle_paused(self):
    self.seek_control.stop_timer()
    self.pause_button.hide()
    self.play_button.show()
    self.play_button.enable()

  def handle_eof(self):
    self.clear_track_info()
    self.seek_control.stop_timer()
    self.pause_button.hide()
    self.play_button.show()
    self.play_button.enable()

#Mediabox controls
  def play(self):
    self.__control.play()

  def pause(self):
    self.__control.pause()

  def next(self):
    self.__control.next()

  def prev(self):
    self.__control.previous()

  def seek(self, pos):
    self.__control.seek(pos*1000)

  def set_volume(self, value):
    self.__control.set_volume(value)

  def get_volume(self):
    self.__control.get_volume()
#GUI
  def set_item_text(self, item, text=''):
    if item:
      item.set_text(text)
      item.set_size_request(-1,-1)

  def create_label(self, text=''):
    label = gtk.Label(text)
    label.modify_bg(gtk.STATE_NORMAL, gtk.gdk.color_parse(self._theme.get_color('mb_background')))
    label.modify_fg(gtk.STATE_NORMAL, gtk.gdk.color_parse(self._theme.get_color('mb_text')))
    label.set_size_request(-1,-1)
    return label

  def screen_changed(self, widget, new_screen=None):
    try:
      screen = widget.get_screen()
      colormap = screen.get_rgba_colormap()
      if colormap:
        self.__has_alpha = True
      else:
        colormap = screen.get_rgb_colormap()
        self.__has_alpha = False
      widget.set_colormap(colormap)
    except:
      pass
    return None

  def do_expose_event(self, widget=None, event=None):
    try:
      cr = Cairo.draw_rounded_rectangle(self, self._theme.get_color('mb_background'), self.__has_alpha, self._theme.get_alpha(), self.corner_radius, draw_background=True)
    except:
      pass
    return None

  def update_widgets_activity(self, value):
    if self.__inforeground != value:
      self.__inforeground = value
      for widget in self.__watch_widgets:
        widget.set_active(self.__inforeground)
