#! /usr/bin/env python
# -*- coding: UTF-8 -*- 

import os, sys, time
import dbus, telepathy

TELEPATHY_ACCOUNT_PREFIX       = '/org/freedesktop/Telepathy/Account/'
TELEPATHY_ACCOUNT_MANAGER_PATH = '/org/freedesktop/Telepathy/AccountManager'

DEBUG = False

def debug(message):
  if DEBUG and sys.stderr.isatty():
    sys.stderr.write('[%f] %s\n' % (time.time(), message))

class AccountMonitor(dbus.Interface):
  __prop_iface = None

  def __init__(self, manager):
    dbus.Interface.__init__(self, manager, telepathy.ACCOUNT_MANAGER)
    self.__prop_iface = dbus.Interface(manager, dbus.PROPERTIES_IFACE)

    self.connect_to_signal('AccountRemoved', self.on_account_removed)
    self.connect_to_signal('AccountValidityChanged', self.on_account_validity_changed)

  def on_account_removed(self, account):
    debug('INFO: AccountMonitor: account removed: %s' % account)

  def on_account_validity_changed(self, account, is_valid):
    debug('INFO: AccountMonitor: account changed: %s (valid=%s)' % (account, is_valid))

if __name__ == '__main__':
  import gobject, dbus.glib

  DEBUG = True

  session = dbus.SessionBus()
  main    = gobject.MainLoop()
  manager = session.get_object(telepathy.ACCOUNT_MANAGER,
                               TELEPATHY_ACCOUNT_MANAGER_PATH)
  monitor = AccountMonitor(manager)

  main.run()

