#ifndef TEXTSELECTIONWIDGET_H
#define TEXTSELECTIONWIDGET_H

#include <QWidget>
#include <QTextLayout>
#include <QPainter>
#include <QAbstractKineticScroller>

class TextSelectionWidget : public QWidget{
    Q_OBJECT
public:
    TextSelectionWidget(QAbstractKineticScroller *s = 0, QWidget *parent = 0);
    void setText(const QString&);
    QString getText();

protected:
    void paintEvent(QPaintEvent*);
    QSize sizeHint() const;
    void mousePressEvent(QMouseEvent*);
    void mouseMoveEvent(QMouseEvent*);
    void mouseReleaseEvent(QMouseEvent*);
    
private:
    QTextLayout *textLayout;
    int margin;
    int lineHeight;

    QAbstractKineticScroller *scroller;
    QPoint scrollPosition;
    qreal panningThreshold;

    QPoint startPoint;
    QPoint endPoint;
    int startPosition;
    int endPosition;

    bool movingStartHandle;
    bool movingEndHandle;
    QPoint startHandlePoint;
    QPoint endHandlePoint;
    QRect startHandleRect;
    QRect endHandleRect;
};

#endif
