#ifndef STARTWINDOW_H
#define STARTWINDOW_H

#include <QMainWindow>
#include <QResizeEvent>
#include <QSettings>

#include "libosso.h"

#include "library.h"
#include "startuplist.h"
#include "mainwindow.h"
#include "settingsdialog.h"
#include "searchcatalogsview.h"

class StartWindow : public QMainWindow
{
    Q_OBJECT
public:
    StartWindow(QWidget *parent = 0);
    ~StartWindow();

protected:
    void resizeEvent(QResizeEvent*);

private:
    StartUpList *startUpList;
    MainWindow *readingUI;
    SearchCatalogsView *searcCatalogsView;
    QListWidget *libraryList;
    QSettings *settings;
    void readSettings();
    Library *library;
    osso_context_t *osso_context;

    FeedBooks *feedBooksCatalog;


public slots:
    void openFile();
    void openBook(Book*);
    void openSettingsDialog();

    void searchCatalogs();
    void searchCatalogsClosed();
    
    void bookViewClosed();

    void showMessage(const QString);

};

#endif
