#ifndef STARTUPLIST_H
#define STARTUPLIST_H

#include <QWidget>
#include <QVBoxLayout>
#include <QScrollArea>
#include <QAbstractKineticScroller>
#include "book.h"

class StartUpList : public QWidget
{
    Q_OBJECT
public:
    StartUpList(QWidget *parent = 0);

    void setScroller(QAbstractKineticScroller*);

private:
    QVBoxLayout *layout;
    QAbstractKineticScroller *scroller;

public slots:
    void addBook(Book *book);
    void openFilePushed();
    void openBookPushed(Book*);
    void searchButtonPressed();

signals:
    void openFile();
    void openBook(Book*);
    void searchCatalogs();
};

#endif
