#include "startuplist.h"

#include <QPushButton>
#include <QLabel>

#include "booklistitem.h"

StartUpList::StartUpList(QWidget *parent) : QWidget(parent)
{
    layout = new QVBoxLayout();
    layout->setSpacing(14);
    setLayout(layout);

    QPushButton *openFileButton = new QPushButton(tr("Open file"), this);
    layout->addWidget(openFileButton);
    layout->setAlignment(openFileButton, Qt::AlignTop);
    layout->setAlignment(Qt::AlignTop);
    connect(openFileButton, SIGNAL(pressed()), this, SLOT(openFilePushed()));

    QPushButton *searchCatalogs = new QPushButton(tr("Search catalogs"), this);
    layout->addWidget(searchCatalogs);
    layout->setAlignment(searchCatalogs, Qt::AlignTop);
    connect(searchCatalogs, SIGNAL(clicked()), this, SLOT(searchButtonPressed()));
    


}

void StartUpList::addBook(Book *book)
{
    BookListItem *item;
    //If scroller is not null pass it to BookListItem. It's used to detect if user is tapping an item or scrolling the QAbstractKineticScroller.
    if(scroller)
        item = new BookListItem(book, scroller, this);
    else
        item = new BookListItem(book, 0, this);
    layout->addWidget(item);
    connect(item, SIGNAL(selected(Book*)), this, SLOT(openBookPushed(Book*)));
    layout->setAlignment(item, Qt::AlignTop);
    //Call adjust size so widget's size is recalculated.
    adjustSize();
}

void StartUpList::setScroller(QAbstractKineticScroller *s)
{
    scroller = s;
}

void StartUpList::openFilePushed()
{
    emit openFile();
}

void StartUpList::openBookPushed(Book *book)
{
    emit openBook(book);
}

void StartUpList::searchButtonPressed()
{
    emit searchCatalogs();
}
