#ifndef PAGE_H
#define PAGE_H

#include <QGraphicsWidget>
#include <QAbstractKineticScroller>
#include <QPainter>
#include <QDebug>

class PixmapWidget : public QGraphicsWidget{
public:
    PixmapWidget(QGraphicsItem *parent = 0, Qt::WindowFlags wFlags = 0) : QGraphicsWidget(parent, wFlags){
        clearPixmap();        
    }
    void setPixmap(QPixmap p){
        pixmaps.clear();
        setGeometry(p.rect());
        pixmaps.push_back(p);
        update();
    }
    void addPixmap(QPixmap p){
        pixmaps.push_back(p);
        update();
    }
    void clearPixmap()
    {
        pixmaps.clear();
    }
protected:
    void paint(QPainter *painter, const QStyleOptionGraphicsItem *option, QWidget *widget = 0){
        Q_UNUSED(option);
        Q_UNUSED(widget);


        int tileY = 0;
        for(int i = 0; i < pixmaps.size(); ++i){
            QPixmap &pixmap = pixmaps[i];
            painter->setPen(Qt::NoPen);
            painter->drawPixmap(0, tileY, pixmap); 
            tileY += pixmap.height();
        }
    }
private:
    QList<QPixmap> pixmaps;
};


class Page : public QGraphicsWidget, public QAbstractKineticScroller{
    Q_OBJECT
public:
    Page(QGraphicsItem *parent = 0, Qt::WindowFlags wFlags = 0);
    void setPixmap(QPixmap);
    void addPixmap(QPixmap);
    void clearPixmap();
    void setContentHeight(int);
    QRectF boundingRect() const;

protected:
   void mousePressEvent(QGraphicsSceneMouseEvent*);
   void mouseReleaseEvent(QGraphicsSceneMouseEvent*);
   void mouseMoveEvent(QGraphicsSceneMouseEvent*);
   void mouseDoubleClickEvent(QGraphicsSceneMouseEvent*);

   QSize viewportSize() const;
   QPoint maximumScrollPosition() const;
   QPoint scrollPosition() const;
   void setScrollPosition(const QPoint&, const QPoint&);
   PixmapWidget *content;
   QPoint overShoot;
};

#endif
