#include "page.h"
#include <QDebug>

Page::Page(QGraphicsItem *parent, Qt::WindowFlags wFlags) : QGraphicsWidget(parent, wFlags)
{
    content = new PixmapWidget(this);
}

void Page::setPixmap(QPixmap p)
{
    content->setPixmap(p);
    update();
}

void Page::addPixmap(QPixmap p)
{
    content->addPixmap(p);
}

void Page::clearPixmap()
{
    content->clearPixmap();
    update();
}

void Page::setContentHeight(int height)
{
    QRectF g = content->geometry();
    content->setGeometry(g.x(), g.y(), g.width(), height);
}

QRectF Page::boundingRect() const
{
    return geometry();
}


void Page::mousePressEvent(QGraphicsSceneMouseEvent *event)
{
    handleMouseEvent(event);
}
void Page::mouseReleaseEvent(QGraphicsSceneMouseEvent *event)
{
    handleMouseEvent(event);
}
void Page::mouseMoveEvent(QGraphicsSceneMouseEvent *event)
{
    handleMouseEvent(event);
}
void Page::mouseDoubleClickEvent(QGraphicsSceneMouseEvent *event)
{
    handleMouseEvent(event);
}

QSize Page::viewportSize() const
{
    return size().toSize();
}
QPoint Page::maximumScrollPosition() const
{
    QSizeF s = content->size() - size();
    return QPoint(qMax(0, int(s.width())), qMax(0, int(s.height())));
}
QPoint Page::scrollPosition() const
{
    return -content->pos().toPoint() + overShoot;
}
void Page::setScrollPosition(const QPoint &p, const QPoint &os)
{
    overShoot = os;
    content->setPos(-p + overShoot);
}
