#ifndef LISTMODEL_H
#define LISTMODEL_H

#include <QAbstractListModel>
#include <QPixmap>
#include <QBuffer>

struct ListItem{
    QString text;
    QString subText;
    QPixmap icon;
};

class ListModel : public QAbstractListModel{
    Q_OBJECT
public:
    ListModel(QList<ListItem> items, QObject *parent = 0) : QAbstractListModel(parent), listItems(items) {}

    int rowCount(const QModelIndex &parent = QModelIndex()) const{
        return listItems.count();
    }

    QVariant data(const QModelIndex &index, int role) const{
        if(!index.isValid())
            return QVariant();

        if(index.row() >= listItems.count())
            return QVariant();

        if(role == Qt::DisplayRole)
            return listItems[index.row()].text;

        if(role == Qt::DecorationRole){
            QByteArray ba;
            QBuffer buffer(&ba);
            buffer.open(QIODevice::WriteOnly);
            listItems[index.row()].icon.save(&buffer, "PNG");
            return ba;
        }

        if(role == Qt::UserRole)
            return listItems[index.row()].subText;
    }

private:
    QList<ListItem> listItems;
};

#endif
