#ifndef LISTITEMDELEGATE_H
#define LISTITEMDELEGATE_H

#include <QApplication>
#include <QDesktopWidget>
#include <QDebug>
#include <QTextLayout>
#include <QStyledItemDelegate>
#include <QPainter>

//TODO: Remove hardcoded margins and other coordinates.

class ListItemDelegate : public QStyledItemDelegate{
    Q_OBJECT
public:
    ListItemDelegate(QWidget *parent = 0) : QStyledItemDelegate(parent), margin(5), screenWidth(0){
        textLayout = new QTextLayout(); 
        screenWidth = QApplication::desktop()->screenGeometry().width();
    }

    void paint(QPainter *painter, const QStyleOptionViewItem &option, const QModelIndex &index) const{
        painter->save();
        QPixmap icon;
        QApplication::style()->drawPrimitive(QStyle::PE_PanelItemViewItem, &option, painter);

        int usedWidth = 0;
        if(icon.loadFromData(index.model()->data(index, Qt::DecorationRole).toByteArray(), "PNG")){
            if(icon.size().height() > (option.rect.height() - 2*margin))
                icon.scaledToHeight((option.rect.height() - 2*margin));

            painter->drawPixmap(option.rect.topLeft() + QPoint(margin, margin*2), icon);

            usedWidth += icon.width() + margin*2;
        }

        QString subText = index.model()->data(index, Qt::UserRole).toString();

        //If there's no subText center the mainText vertically.
        int mainTextY = margin;
        if(subText.isEmpty()){
            mainTextY = (option.rect.height() / 2) - (textLayout->boundingRect().height() / 2);
        }

        textLayout->draw(painter, option.rect.topLeft() + QPoint(usedWidth + margin, mainTextY));

        QFontMetrics metrics = option.fontMetrics;
        int usedHeight = textLayout->boundingRect().height() + margin*2;

        if(!subText.isEmpty()){
            QFont font = option.font;
            font.setPointSize(14);
            painter->setFont(font);
            painter->setPen(Qt::lightGray);
            painter->setBrush(Qt::lightGray);
            painter->drawText(option.rect.topLeft() + QPoint(usedWidth + margin, usedHeight + metrics.height()/2), subText); 
        }


        painter->restore();
            
    }

    QSize sizeHint(const QStyleOptionViewItem &option, const QModelIndex &index) const{
        int iconWidth = 32;
        int mainTextWidth = 0;
        int mainTextHeight = 0;
        int subTextHeight = 0;

        QString mainText = index.model()->data(index, Qt::DisplayRole).toString();
        textLayout->setText(mainText);
        textLayout->beginLayout();
        qreal height = 0;
        while(1){
            QTextLine line = textLayout->createLine();
            if(!line.isValid())
                break;

            line.setLineWidth((screenWidth-(margin*2))-iconWidth);
            line.setPosition(QPointF(0, height));
            height += line.height();
        }
        textLayout->endLayout();
        mainTextHeight = height;
        mainTextWidth = option.rect.width()-margin-iconWidth;

        QString subText = index.model()->data(index, Qt::UserRole).toString();
        if(!subText.isEmpty()){
            QFontMetrics metrics = option.fontMetrics;
            QFont font = option.font;
            font.setPixelSize(14);
            subTextHeight = metrics.height();
        }
        
        //Make sure list element is at least 70 pixels in height
        int itemHeight = margin + mainTextHeight + margin + subTextHeight + margin;
        if(itemHeight < 70)itemHeight = 70;

        QSize hint(iconWidth + mainTextWidth + margin*3, itemHeight);
        return hint;

    }

private:
    int margin;
    QTextLayout *textLayout;
    int screenWidth;
};
#endif
