#ifndef DOWNLOADMANAGER_H
#define DOWNLOADMANAGER_H

#include <QHBoxLayout>
#include <QVBoxLayout>
#include <QLabel>
#include <QProgressBar>

class DownloadManagerItem : public QWidget{
    Q_OBJECT
public:
    DownloadManagerItem(const QString &filename, QNetworkReply *reply, QWidget *parent = 0) : QWidget(parent){
        bookFilename = filename;

        QHBoxLayout *mainLayout = new QHBoxLayout(this);

        QVBoxLayout *subLayout = new QVBoxLayout();
        titleLabel.setText(bookFilename);
        subLayout->addWidget(&titleLabel);

        subLayout->addWidget(&downloadProgressBar);

        mainLayout->addLayout(subLayout);

        QVBoxLayout *subLayout2 = new QVBoxLayout();

        QPushButton *cancelButton = new QPushButton(tr("Cancel"), this);
        subLayout2->addWidget(cancelButton);

        QPushButton *openFileButton = new QPushButton(tr("Open"), this);
        openFileButton->setDisabled(true);
        subLayout2->addWidget(openFileButton);

        mainLayout->addLayout(subLayout2);

        networkReply = reply;

        connect(reply, SLOT(finished()), this, SLOT(downloadFinished()));
        connect(reply, downloadProgress(qint64, qint64), this, SLOT(updateProgress(qint 64, qint64)));
        connect(cancelButton, SIGNAL(clicked()), this, SLOT(cancelDownload()));
    }

    void setTitle(const QString &title){
        titleLabel.setText(title); 
    }
//    void setFilename(const QString& filename){}

private:
    QLabel titleLabel;
    QProgressBar downloadProgressBar;
    QString bookFilename; 
    QNetworkReply *networkReply;

public slots:
    void updateProgress(qint64 received, qint64 total){ 
        downloadProgressBar.setMaximum(total);
        downloadProgressBar.setValue(received);
    }

    //TODO: move this to a non-GUI class
    void downloadFinished()
    {
        if(networkReply->error() == QNetworkReply::NoError){
            if(networkReply->open(QIODevice::ReadOnly)){
                qDebug() << "Ready to save file";
                QByteArray ba = networkReply->readAll();
                QFile bookFile("/home/user/MyDocs/books/" + bookFilename);
                bookFile.open(QIODevice::WriteOnly);
                bookFile.write(ba);
            }
        }
    }

    void cancelDownload()
    {
        reply->abort();
        reply->deleteLater();
        downloadProgressBar.setDisabled(true);
    }
signals:
    void openFile(const QString&);

};

class DownloadManager : public QWidget{
    Q_OBJECT
public:
    DownloadManager(QWidget *parent = 0);
    void download(const QString&);

public slots:
    void addDownload(const QString&, QNetworkReply*, const QString& = QString());

private:
    QVBoxLayout *mainLayout;
};

#endif
