#ifndef COLORVALUEBUTTON_H
#define COLORVALUEBUTTON_H

#include <QMaemo5ValueButton>
#include <QMaemo5AbstractPickSelector>
#include <QIcon>
#include <QPainter>

class ColorValueButton : public QMaemo5ValueButton{
    Q_OBJECT
public:
    ColorValueButton(QWidget *parent = 0) : QMaemo5ValueButton(parent){
    }

    //Set the icon from the textValue returned from the picker
    void setValueText(const QString &text){
        QColor color(text);
        QPixmap pm(32, 32);
        pm.fill(Qt::transparent);
        QPainter painter(&pm); 
        painter.setRenderHint(QPainter::Antialiasing, true);
        painter.setBrush(QBrush(color));
        painter.setPen(Qt::NoPen);
        painter.drawRoundedRect(pm.rect(), 3, 3);
        QIcon icon(pm);

        setIcon(icon);
        setIconSize(QSize(32, 32));

        //Call parent class's implementation. This sets the text of the button.
        QMaemo5ValueButton::setValueText(text);

    }
};

#endif
