#ifndef COLORSELECTORDIALOG_H
#define COLORSELECTORDIALOG_H

#include <QDialog>
#include <QGridLayout>
#include <QHBoxLayout>
#include <QVBoxLayout>
#include <QButtonGroup>
#include <QRadioButton>
#include <QPainter>
#include <QApplication>
#include <QDesktopWidget>

class ColorSelectorDialog : public QDialog{
    Q_OBJECT
public:
    ColorSelectorDialog(QList<QColor> colors, QWidget *parent = 0) : QDialog(parent){
        table = new QGridLayout();
        //Set dialog modal or it won't show correctly
        setModal(true);
        setWindowTitle(tr("Pick a color"));
        int row = 0;
        int col = 0;
        int colorsToCol = 5;
        QRect screenGeometry = QApplication::desktop()->screenGeometry();
        if(screenGeometry.width() > screenGeometry.height())
            colorsToCol = 9;
        colorButtonGroup = new QButtonGroup();
        for(int i = 0; i < colors.count(); ++i)
        {
            QPixmap pi(38, 38);
            pi.fill(Qt::transparent);
            QPainter painter(&pi);
            painter.setRenderHint(QPainter::Antialiasing, true);
            painter.setPen(Qt::NoPen);
            painter.setBrush(colors.at(i));
            painter.drawRoundedRect(pi.rect(), 3, 3);
            QRadioButton *item = new QRadioButton();
            colorButtonGroup->addButton(item, i);
            item->setMaximumSize(pi.size() + QSize(20, 20));
            item->setIconSize(pi.size());
            item->setIcon(QIcon(pi));
            table->addWidget(item,row, col, Qt::AlignCenter);
            col++;
            if(col >= colorsToCol){
                row++;
                col = 0;
            }
        } 
        setLayout(table);         
        connect(colorButtonGroup, SIGNAL(buttonClicked(int)), this, SLOT(colorSelected(int)));

    }

public slots:
    void colorSelected(int id){
        emit selected(id); 
        hide();
    }

signals:
    void selected(int);

private:
    QGridLayout *table;
    QButtonGroup *colorButtonGroup;
};

#endif
