#ifndef BOOKVIEW_H
#define BOOKVIEW_H

#include <QGraphicsView>
#include <QThread>
#include <QTimer>
#include "libosso.h"
#include "book.h"
#include "shared.h"
#include "page.h"
#include "rendersettings.h"
#include "renderer.h"
#include "scrollablepage.h"


class BookView : public QGraphicsView
{
    Q_OBJECT
public:
    BookView(QWidget *parent = 0);
    ~BookView();
    void setBook(Book*);
    void goToSection(int, int page = 0);

    void setFont(const QString&, int);
    void setNightMode(bool);
    void setViewMode(BookViewMode);

    void addBookmark(QString, QColor);

protected:
    void mousePressEvent(QMouseEvent*);
    void mouseMoveEvent(QMouseEvent*);
    void mouseReleaseEvent(QMouseEvent*);
    void resizeEvent(QResizeEvent*);

private:
    Book *book;
    QString currentChapter;
    int currentSection;
    int currentPage;
    QPoint swipeStart;
    BookViewMode viewMode;
    bool snapEnabled;
    QSizeF pageSize;
    RenderSettings renderSettings;

    QPixmap loadingPixmap();


    Page *pageWidgetCurrent;
    Page *pageWidgetNext;
    QGraphicsScene *scene;
    ScrollablePage *scrollablePage;

//    QList<RenderTile> tiles;
    QHash<int, QList<RenderTile> > tiles;
    Renderer *renderer;
    QThread *renderingThread;
    void nextPage();
    void previousPage();
    QPixmap getCurrentPagePixmap();
    QPixmap getNextPagePixmap();
    QPixmap getPreviousPagePixmap();

    QTimer autoScrollTimer;
    const int autoScrollStep;
    int autoScrollBy; 

    QString annotationParagraph;

    bool isTap;
    int tapMove;


public slots:
    void goToChapter(QString);
    void goToBookmark(int);
    void goToAnnotation(int);
    void volumeUpPressed();
    void volumeDownPressed();
    void saveProgress();
    void addTile(RenderTile);
    void contentHeight(int);
    void webPageLoaded(QWebPage*);
    void handleAutoScroll();
    void openContextMenu(const QPoint&);
    void addBookmark();
    void addAnnotation();

signals:
    void requestRender(QString, int);

};

#endif
