#ifndef BOOKLISTITEM_H
#define BOOKLISTITEM_H

#include <QWidget>
#include <QApplication>
#include <QHBoxLayout>
#include <QVBoxLayout>
#include <QLabel>
#include <QFrame>
#include <QPainter>
#include <QLinearGradient>
#include <QAbstractKineticScroller>
#include "book.h"

//TODO:Remove dependancy on Book, class should be independent from others 
//Replace with a delegate?

class BookListItem : public QFrame{
    Q_OBJECT
public:
    BookListItem(Book *book, QAbstractKineticScroller *scrollable = 0, QWidget *parent = 0) : QFrame(parent){
        thisBook = book;

        mainLayout = new QHBoxLayout();
//        mainLayout->setContentsMargins(margins);
        QPixmap temp = book->getCoverImage();
        if(!temp.isNull()){
            QLabel *image = new QLabel(this);
            temp = temp.scaledToWidth(100);
            image->setPixmap(temp);
            image->setFixedWidth(temp.width());
            mainLayout->addWidget(image);
            mainLayout->setAlignment(image, Qt::AlignLeft | Qt::AlignTop);
        }

        connect(thisBook, SIGNAL(coverImageAdded()), this, SLOT(coverImageAdded()));

        QVBoxLayout *subLayout = new QVBoxLayout();
//        subLayout->setContentsMargins(margins);
        mainLayout->addLayout(subLayout);

        QLabel *title = new QLabel(book->getTitle(), this);
        title->setWordWrap(true);

        subLayout->addWidget(title);

        QLabel *author = new QLabel(book->getAuthor(), this);
        author->setWordWrap(true);
        author->setSizePolicy(QSizePolicy::MinimumExpanding, QSizePolicy::MinimumExpanding);
        subLayout->addWidget(author);

        QString subject = book->getSubject();
        if(!subject.isEmpty() && !subject.isNull()){
            QLabel *category = new QLabel(subject, this);
            category->setFont(QFont("Sans", 12));
            category->setWordWrap(true);
            category->setSizePolicy(QSizePolicy::MinimumExpanding, QSizePolicy::MinimumExpanding);
            subLayout->addWidget(category);
        }
        subLayout->setSpacing(0);
        subLayout->addStretch(1);

        QVBoxLayout *superLayout = new QVBoxLayout(this);


        superLayout->addLayout(mainLayout);


        QMargins margins(6, 4, 4, 4);
        superLayout->setContentsMargins(margins);

        setLayout(superLayout);

        scroller = scrollable;

        QString frameStyleSheet = "BookListItem{width: 100%;border: 3px solid #eeeeec;border-radius: 12px; background-color: #1a1a1a;}";

        setStyleSheet(frameStyleSheet);

    }
protected:
    void mouseReleaseEvent(QMouseEvent *event){
        if(scroller){
            if(scroller->state() == QAbstractKineticScroller::Inactive)
                emit selected(thisBook);
        }
        QString frameStyleSheet = "BookListItem{width: 100%;border: 3px solid #eeeeec;border-radius: 12px; background-color: #1a1a1a;}";
        setStyleSheet(frameStyleSheet);
    }

    void mousePressEvent(QMouseEvent *event){
        QPalette palette;
        palette.setCurrentColorGroup(QPalette::Active);
        QBrush brush = palette.highlight();
        QString frameStyleSheet = "BookListItem{width: 100%;border: 3px solid #eeeeec;border-radius: 12px; background-color: " + brush.color().name() + ";}";
        setStyleSheet(frameStyleSheet);
    }

private:
    Book *thisBook;
    QAbstractKineticScroller *scroller;
    QHBoxLayout *mainLayout;
    QFrame *separator;
    QFrame *topSeparator;
    QLinearGradient gradient;

signals:
    void selected(Book*);

public slots:
    void coverImageAdded(){
        QPixmap temp = thisBook->getCoverImage();
        if(!temp.isNull()){
            QLabel *image = new QLabel(this);
            temp = temp.scaledToWidth(100);
            image->setPixmap(temp);
            image->setFixedWidth(temp.width());
            mainLayout->insertWidget(0, image);
            mainLayout->setAlignment(image, Qt::AlignLeft | Qt::AlignTop);
            adjustSize();
        }
    }
};

#endif
