#ifndef ADDBOOKMARKDIALOG_H
#define ADDBOOKMARKDIALOG_H
#include <QDebug>

#include <QDialog>
#include <QColor>
#include <QPainter>
#include <QLineEdit>
#include <QGridLayout>
#include <QRadioButton>
#include <QButtonGroup>
#include <QDialogButtonBox>
#include <QHBoxLayout>
#include <QVBoxLayout>
#include <QScrollArea>

#include "colorselector.h"
#include "colorvaluebutton.h"
#include <QMaemo5ValueButton>

class AddBookmarkDialog : public QDialog{
    Q_OBJECT
public:
    AddBookmarkDialog(QWidget *parent = 0) : QDialog(parent){
        setWindowTitle(tr("Add bookmark"));
        //Colors used are from the Tango palette
        QList<QColor> colors;
        colors.push_back(QColor("#fce94f"));
        colors.push_back(QColor("#edd400"));
        colors.push_back(QColor("#c4a000"));

        colors.push_back(QColor("#fcaf3e"));
        colors.push_back(QColor("#f57900"));
        colors.push_back(QColor("#ce5c00"));

        colors.push_back(QColor("#e9b96e"));
        colors.push_back(QColor("#c17d11"));
        colors.push_back(QColor("#ce5c00"));

        colors.push_back(QColor("#8ae234"));
        colors.push_back(QColor("#73d216"));
        colors.push_back(QColor("#4e9a06"));

        colors.push_back(QColor("#729fcf"));
        colors.push_back(QColor("#3465a4"));
        colors.push_back(QColor("#204a87"));

        colors.push_back(QColor("#ad7fa8"));
        colors.push_back(QColor("#75507b"));
        colors.push_back(QColor("#5c3566"));

        colors.push_back(QColor("#ef2929"));
        colors.push_back(QColor("#cc0000"));
        colors.push_back(QColor("#a40000"));

        colors.push_back(QColor("#eeeeec"));
        colors.push_back(QColor("#d3d7cf"));
        colors.push_back(QColor("#babdb6"));

        colors.push_back(QColor("#888a85"));
        colors.push_back(QColor("#555753"));
        colors.push_back(QColor("#2e3436"));

        QHBoxLayout *mainLayout = new QHBoxLayout(this);
        QVBoxLayout *layout = new QVBoxLayout();

        name = new QLineEdit(this);
        name->grabKeyboard();

        layout->addWidget(name);

        ColorValueButton *colorButton = new ColorValueButton();
        colorSelector = new ColorSelector(colors);
        colorButton->setPickSelector(colorSelector);
        layout->addWidget(colorButton);

        mainLayout->addLayout(layout);
        mainLayout->setStretch(0, 1);

        QDialogButtonBox *buttonBox = new QDialogButtonBox(QDialogButtonBox::Save);
        connect(buttonBox, SIGNAL(accepted()), this, SLOT(accept()));

        QVBoxLayout *subLayout = new QVBoxLayout();
        subLayout->setSizeConstraint(QLayout::SetMinimumSize);
        mainLayout->addLayout(subLayout);

        subLayout->addWidget(buttonBox);
        subLayout->setAlignment(buttonBox, Qt::AlignBottom);

    }

    QString getName()
    {
        return name->text();
    }

    QColor getColor()
    {
        return QColor(colorSelector->currentValueText());
    }
private:
    QLineEdit *name;
    ColorSelector *colorSelector;

};

#endif
