#include "epubdocument.h"
#include <QStringList>
#include <QDebug>

EpubDocument::EpubDocument(const QString &filename, QObject *parent) : QTextDocument(parent)
{
    mEpub = epub_open(qPrintable(filename), 0);
}

bool EpubDocument::isValid()
{
    return (mEpub?true:false);

}

EpubDocument::~EpubDocument(){
    if(mEpub)
        epub_close(mEpub);

    epub_cleanup();
}


struct epub *EpubDocument::getEpub()
{
    return mEpub;
}

QVariant EpubDocument::loadResource(int type, const QUrl &name){
    int size;
    char *data;
    
    QString n = name.toString();
    if(n.contains(".css")){
        if(!n.contains("css/")){
            n = "css/" + n;
        }
    }
    size = epub_get_data(mEpub, n.toUtf8(), &data);

    QVariant res;

    if(size > 0){
        switch(type){
        case QTextDocument::ImageResource:
                res.setValue(QImage::fromData((unsigned char *)data, size));
            break;
        default:
                res.setValue(QString::fromUtf8(data));
            break;
        }
        free(data);
    }
    addResource(type, n, res);
    return res;
}
