#ifndef RENDERER_H
#define RENDERER_H

#include <QPixmap>
#include <QThread>
#include <QQueue>
#include <QImage>
#include <QNetworkAccessManager>
#include <QWebElement>
#include <QWebPage>
#include <QWebFrame>
#include "shared.h"
#include "rendersettings.h"

#include "annotation.h"

class RenderTile{
public:
    RenderTile(){}
    RenderTile(int s, int i, QPoint p, QSizeF si, QPixmap pi){
        section = s;
        id = i;
        pos = p;
        size = si;
        pixmap = pi;
    }

    QPixmap& getPixmap(){return pixmap;}
    int getID(){return id;}
    int getSection(){return section;}
    const QPoint& getPosition(){return pos;}
    void updatePixmap(QPixmap p){
        pixmap = p;
    }

private:
    int section;
    int id;
    QPoint pos;
    QSizeF size;
    QPixmap pixmap;
};

class Renderer : public QObject{
    Q_OBJECT
public:
    Renderer(QObject *parent = 0);
    ~Renderer();
    void setResourceManager(QNetworkAccessManager*);
    void renderTile(RenderTile&);
    void setPageSize(QSizeF);
    void setRenderSettings(RenderSettings*);
    void setAnnotations(QList<Annotation>);
    void enablePagination(bool);
    void enablePixmapRendering(bool);
    QString getParagraphAt(const QPoint&, RenderTile* = 0);
    bool hitAnnotation(const QPoint&, QString&, RenderTile* = 0);

private:
    void handleQueue();
    void setCSSSetting(QString, QString);
    void setHTMLAttribute(QString, QString);
    void makeDOMChangesEffective();
    void setDOMElementSettings(QWebElement&);
    void parseLinks(QString&);

    QHash<QString, QString> cssSettings;
    QHash<QString, QString> htmlAttributes;
    QList<Annotation> annotationList;
    QWebPage *page;
    QQueue< QPair<int, QString> > queue;
    QPair<int, QString> current;
    QSizeF pageSize;

    RenderSettings *renderSettings;

    bool paginate;
    bool pixmapRendering;

signals:
    void tileRendered(RenderTile);
    void contentHeight(int);
    void webPageLoaded(QWebPage*);

public slots:
    void render();
    void addToQueue(QString, int);
//    void addToQueue(QString, int, QList<Annotation>);
//    void addToQueue(QString, int, int, int);
};

#endif
