#ifndef LIBRARY_H
#define LIBRARY_H

class QObject;
#include <QSqlDatabase>
#include <QSqlQuery>
#include <QStringList>
#include <QDir>
#include "book.h"

class Library : public QObject{
    Q_OBJECT
public:
    Library(const QString &lD, const QString &databasename, QObject *parent = 0);
    ~Library();
    void loadLibrary();

    void scanDirectory(const QString&);

    void loadBooksfromdb();
    void saveBooktodb(Book*);
    QList<Book*> getBooks();

private:
    QStringList filenames;
    void connectdb(const QString&);
    void saveBookProgress(Book*);
    void loadBookProgress(Book*);
    void saveBookmarks(Book*);
    void loadBookmarks(Book*);
    void saveAnnotations(Book*);
    void loadAnnotations(Book*);
    bool checkForChanges();

    QSqlDatabase database;
    QString libraryDirectory;

    QList<Book*> books;

public slots: 
    void addToLibrary(Book*);
    void addToLibrary(const QString&);

signals:
    void bookAdded(Book*);
};

#endif
