#ifndef CATALOG_H
#define CATALOG_H

#include <QObject>

#include "book.h"

class Catalog : public QObject{
    Q_OBJECT
public:
    Catalog(QObject *parent = 0);
    void searchBooks(const QString&);
    void download(Book*, bool = false);
    void getCoverImage(const QString&, Book*);

private:
    virtual void parseBooks(const QString&) = 0;

protected:
    QString searchUrl;
    QString downloadUrl;
    QHash<QString, Book*> currentBooks;
    QHash<QNetworkReply*, Book*> downloading;
    QHash<QNetworkReply*, Book*> downloadingCovers;

    QNetworkAccessManager *networkManager;
    QNetworkAccessManager *coverDownloader;
    QNetworkReply *searchReply;

    Book *openAfterDownload;

public slots:
    void searchReady();
    void saveBook(QNetworkReply*);
    void coverDownloaded(QNetworkReply*); 
    void error(QNetworkReply::NetworkError);

signals:
    void addBook(Book*);
    void bookSaved(QString);
    void bookSaved(Book*);
    void foundBooksCount(int);
    void openBook(Book*);

    void message(const QString);
};

#endif
