#ifndef BOOK_H
#define BOOK_H

#include <QTextDocument>
#include <QTextBlock>
#include <QHash>
#include <QList>
#include <QDate>
#include <QObject>

#include "epubgenerator.h"
#include "bookmark.h"
#include "annotation.h"

class BookProgress
{
public:
    BookProgress() : scrollProgress(0), progressSection(0), progressPage(0){}
    //TODO: Check for correct values.
    void setProgress(int scroll, int section = 0, int page = 0){
        scrollProgress = scroll;
        progressSection = section;
        progressPage = page;
        
    }

    int getScroll(){return scrollProgress;}
    inline int getPage(){return progressPage;}
    int getSection(){return progressSection;}
    bool isValid(){ 
        return (scrollProgress+progressSection+progressPage)>0?true:false;
    }
private:
    //Variables for saving book progress
    int scrollProgress;
    int progressSection;
    int progressPage;
};

class Book : public QObject
{
    Q_OBJECT
public:
    Book();
    Book(const QString &bookFilename, bool loadLater = false);
    ~Book();

    void openBook(const QString &bookFilename);
    void loadMetaData();
    void load();
    bool isLoaded();

    QString getFirstChapter();
    QString getNextChapter(QString&);
    QString getChapter(QString);

    QString getCover();
    QString getNextSection(int &number);
    QString getPreviousSection(int &number);
    const QString& getSection(int);
    int getSectionNumber(QString);
    const QString& getSectionName(int);
    QString getBook();
    QList<QString> getTOC();

    void setFilename(QString);
    QString getFilename();

    bool hasTOC();
    const QString& getTitle();
    const QString& getAuthor();
    const QString& getCategory();
    const QPixmap& getCoverImage();
    const QString& getSubject();
    const QString& getDescription();
    const QString& getPublishDate();
    int getNumberOfSections();

    unsigned int getLengthInWords();
    void setLengthInWords(unsigned int);

    BookProgress getProgress();
    void setProgress(BookProgress);

    QList<Bookmark> getBookmarks();
    void addBookmark(Bookmark);

    QList<Annotation> getAnnotations();
    void addAnnotation(Annotation);
    Annotation* getAnnotation(const QString&);

    bool isInLibrary();
    void changeLibraryStatus(bool);

    QNetworkAccessManager *getResourceManager();

private:
    QString title;
    QString author;
    QString publisher;
    QString description;
    QString subject;
    QString publishDate;
    QString category;
    QString copyright;
    QString filename;

    unsigned int lengthInWords;
    
    QList<QString> toc;

    QHash<QString, QString*> document;
    QList<QString*> sections;

    QPixmap coverImage;

    QList<Bookmark> bookmarks;
    QList<Annotation> annotations;

    EpubGenerator *generator;

    BookProgress bookProgress;

    bool loaded;

    bool inLibrary;

    void setUpGenerator();


public slots:
    void setTitle(QString);
    void setAuthor(QString);
    void setPublisher(QString);
    void setDescription(QString);
    void setSubject(QString);
    void setPublishDate(QString);
    void setCategory(QString);
    void setCopyright(QString);

    void addChapter(QString, QString*);
    void addTOCItem(QString);
    void addSection(QString*);

    void addCoverImage(QPixmap);

signals:
    void coverImageAdded();

};

#endif
