#ifndef STARTWINDOW_H
#define STARTWINDOW_H

#include <QMainWindow>
#include <QResizeEvent>
#include <QSettings>

#include "library.h"
#include "startuplist.h"
#include "mainwindow.h"
#include "settingsdialog.h"

class StartWindow : public QMainWindow
{
    Q_OBJECT
public:
    StartWindow(QWidget *parent = 0);
    ~StartWindow();

protected:
    void resizeEvent(QResizeEvent*);

private:
    StartUpList *startUpList;
    MainWindow *readingUI;
    QListWidget *libraryList;
    QSettings *settings;
    void readSettings();
    Library *library;


public slots:
    void openFile();
    void openBook(Book*);
    void openSettingsDialog();

};

#endif
