#include "startwindow.h"
#include "mainwindow.h"

#include <QScrollArea>
#include <QFileDialog>
#include <QMenuBar>


StartWindow::StartWindow(QWidget *parent) : QMainWindow(parent)
{
    QScrollArea *scrollArea = new QScrollArea(this);
    setCentralWidget(scrollArea);

    startUpList = new StartUpList(this);
    scrollArea->setWidget(startUpList);
    //Pass scrollArea's QAbstractKineticScroller to StartUpList. It's used to detect if user is tapping an item or scrolling the QAbstractKineticScroller.
    //TODO: There might be a better way to do this..
    QAbstractKineticScroller *scroller = scrollArea->property("kineticScroller").value<QAbstractKineticScroller*>();
    startUpList->setScroller(scroller);

    scrollArea->setHorizontalScrollBarPolicy(Qt::ScrollBarAlwaysOff);

    connect(startUpList, SIGNAL(openBook(Book*)), this, SLOT(openBook(Book*)));
    
    setAttribute(Qt::WA_Maemo5StackedWindow);

    connect(startUpList, SIGNAL(openFile()), this, SLOT(openFile()));

    QMenuBar *menuBar = new QMenuBar(this);
    QAction *settings = menuBar->addAction(tr("Settings"));
    connect(settings, SIGNAL(triggered()), this, SLOT(openSettingsDialog()));

    setMenuBar(menuBar);

    readSettings();

    library = new Library("/home/user/MyDocs/books", "/home/user/MyDocs/bookdb.db", this);

    QList<Book*> books = library->getBooks(); 
    for(QList<Book*>::iterator iter = books.begin(); iter != books.end(); ++iter){
        startUpList->addBook((*iter));
    }


}

StartWindow::~StartWindow()
{
}

void StartWindow::resizeEvent(QResizeEvent *event)
{
    startUpList->setFixedWidth(event->size().width()-10);
}


void StartWindow::readSettings()
{

    settings = new QSettings("juhana.jauhiainen@gmail.com", "Maemo eBook reader");

    setAttribute(static_cast<Qt::WidgetAttribute>(settings->value("orientation").toInt()), true);


}

void StartWindow::openFile()
{
    QString filename = QFileDialog::getOpenFileName(this, tr("Open book"), "/home/user/MyDocs", tr("eBook Files (*.epub)"));
    
    if(!filename.isEmpty()){
        Book *book = new Book(filename);
        openBook(book);
    }
}

void StartWindow::openBook(Book *book)
{
    if(!readingUI)
        readingUI = new MainWindow(this);

    readingUI->setFont(settings->value("font-family").toString(), settings->value("font-size").toInt());
    readingUI->setColorMode(!settings->value("colors").toBool());
    readingUI->openBook(book);
    readingUI->show();

}

void StartWindow::openSettingsDialog()
{
    SettingsDialog *settingsDialog = new SettingsDialog(this);    
    settingsDialog->setOrientation(settings->value("orientation").toInt());
    settingsDialog->setColors(settings->value("colors").toInt());
    settingsDialog->setFontFamily(settings->value("font-family").toString());
    settingsDialog->setFontSize(settings->value("font-size").toInt());


    if(settingsDialog->exec() == QDialog::Accepted){
        int orientation = settingsDialog->getOrientation();
        if(orientation != settings->value("orientation")){
            settings->setValue("orientation", orientation); 
            setAttribute(static_cast<Qt::WidgetAttribute>(orientation), true);
        }

        int colors = settingsDialog->getColors();
        if(colors != settings->value("colors")){
            settings->setValue("colors", colors);
        }

        settings->setValue("font-family", settingsDialog->getFontFamily());
        settings->setValue("font-size", settingsDialog->getFontSize());
    }
}

