#include "startuplist.h"

#include <QPushButton>
#include <QLabel>

#include "booklistitem.h"

StartUpList::StartUpList(QWidget *parent) : QWidget(parent)
{
    layout = new QVBoxLayout();
    setLayout(layout);

    QPushButton *openFileButton = new QPushButton(tr("Open file"), this);
    layout->addWidget(openFileButton);

    connect(openFileButton, SIGNAL(pressed()), this, SLOT(openFilePushed()));

}

StartUpList::~StartUpList()
{

}

void StartUpList::addBook(Book *book)
{
    BookListItem *item;
    //If scroller is not null pass it to BookListItem. It's used to detect if user is tapping an item or scrolling the QAbstractKineticScroller.
    if(scroller)
        item = new BookListItem(book, this, scroller);
    else
        item = new BookListItem(book, this);
    layout->addWidget(item);
    connect(item, SIGNAL(selected(Book*)), this, SLOT(openBookPushed(Book*)));
    layout->setAlignment(item, Qt::AlignTop);
    //Call adjust size so widget's size is recalculated.
    adjustSize();
}

void StartUpList::setScroller(QAbstractKineticScroller *s)
{
    scroller = s;
}

void StartUpList::openFilePushed()
{
    emit openFile();
}

void StartUpList::openBookPushed(Book *book)
{
    emit openBook(book);
}
