#ifndef SETTINGSDIALOG_H
#define SETTINGSDIALOG_H

#include <QDialog>
#include <QRadioButton>
#include <QtMaemo5>


class SettingsDialog : public QDialog
{
    Q_OBJECT
public:
    SettingsDialog(QWidget *parent = 0);

    int getOrientation();
    void setOrientation(int);

    int getColors();
    void setColors(int);

    void setFontFamily(const QString &family);
    QString getFontFamily();

    void setFontSize(int size);
    int getFontSize();

private:
    QButtonGroup *orientationButtonGroup;
    QRadioButton *portraitRadioButton;
    QRadioButton *landscapeRadioButton;
    QButtonGroup *colorsButtonGroup;
    QRadioButton *normalRadioButton;
    QRadioButton *invertedRadioButton;
    QMaemo5ListPickSelector *fontSelector;
    QStandardItemModel *model;
    QHash<QString, QStandardItemModel*> fontSizes;
    QMaemo5ListPickSelector *fontSizeSelector;

public slots:
    void fontChanged(const QString&);
};

#endif
