#include "settingsdialog.h"

#include <QVBoxLayout>
#include <QHBoxLayout>
#include <QPushButton>
#include <QFontDatabase>

SettingsDialog::SettingsDialog(QWidget *parent) : QDialog(parent)
{
    QHBoxLayout *mainLayout = new QHBoxLayout(this); 
    setLayout(mainLayout);

    QVBoxLayout *subLayout = new QVBoxLayout();

    mainLayout->addLayout(subLayout);

    
    QPushButton *saveButton = new QPushButton(tr("Save"), this);
    saveButton->setMaximumWidth(200);

    connect(saveButton, SIGNAL(pressed()), this, SLOT(accept()));

    QVBoxLayout *subLayout2 = new QVBoxLayout();
    mainLayout->addLayout(subLayout2);

    subLayout2->addWidget(saveButton);

    subLayout2->setAlignment(saveButton, Qt::AlignBottom);

    QHBoxLayout *orientationLayout = new QHBoxLayout();

    portraitRadioButton = new QRadioButton(tr("Portrait"), this);
    landscapeRadioButton = new QRadioButton(tr("Landscape"), this);
    orientationLayout->setSpacing(0);
    subLayout->addLayout(orientationLayout);

    orientationLayout->addWidget(portraitRadioButton);
    orientationLayout->addWidget(landscapeRadioButton);

    QButtonGroup *orientationButtonGroup = new QButtonGroup();
    orientationButtonGroup->addButton(portraitRadioButton);
    orientationButtonGroup->addButton(landscapeRadioButton);

    QHBoxLayout *colorsLayout = new QHBoxLayout();

    normalRadioButton = new QRadioButton(tr("Normal"), this);
    invertedRadioButton = new QRadioButton(tr("Inverted"), this);
    colorsLayout->setSpacing(0);
    subLayout->addLayout(colorsLayout);

    colorsLayout->addWidget(normalRadioButton);
    colorsLayout->addWidget(invertedRadioButton);

    QButtonGroup *colorsButtonGroup = new QButtonGroup();
    colorsButtonGroup->addButton(normalRadioButton);
    colorsButtonGroup->addButton(invertedRadioButton);


    model = new QStandardItemModel(0, 1);
    QFontDatabase fontDB;
    QStringList families = fontDB.families(); 

    QStringList::const_iterator iter;
    for(iter = families.constBegin(); iter != families.constEnd(); ++iter){
        QStandardItem *item = new QStandardItem(*iter);
        item->setTextAlignment(Qt::AlignCenter);
        item->setEditable(false);
        model->appendRow(item);

        QList<int> sizes = fontDB.smoothSizes(*iter, "Normal");
        QStandardItemModel *smodel = new QStandardItemModel(0, 1);
        for(QList<int>::iterator siter = sizes.begin(); siter != sizes.end(); ++siter)
        {
            QStandardItem *sitem = new QStandardItem(QString::number(*siter));
            smodel->appendRow(sitem);
        }
        fontSizes.insert(*iter, smodel);
    }

    QMaemo5ValueButton *fontButton = new QMaemo5ValueButton(tr("Font"));
    fontButton->setValueLayout(QMaemo5ValueButton::ValueUnderText);
    fontSelector = new QMaemo5ListPickSelector;
    fontSelector->setModel(model);
    fontSelector->setCurrentIndex(0);
    fontButton->setPickSelector(fontSelector);
    connect(fontSelector, SIGNAL(selected(const QString&)), this, SLOT(fontChanged(const QString&)));
    subLayout->addWidget(fontButton);

    QMaemo5ValueButton *fontSizeButton = new QMaemo5ValueButton(tr("Font size"));
    fontSizeButton->setValueLayout(QMaemo5ValueButton::ValueUnderText);
    fontSizeSelector = new QMaemo5ListPickSelector;
    fontSizeButton->setPickSelector(fontSizeSelector);
    fontSizeSelector->setModel(fontSizes[0]);
    fontSizeSelector->setCurrentIndex(0);
    subLayout->addWidget(fontSizeButton);

}

int SettingsDialog::getOrientation()
{
    if(portraitRadioButton->isChecked())return Qt::WA_Maemo5PortraitOrientation;
    else return Qt::WA_Maemo5LandscapeOrientation;
}

void SettingsDialog::setOrientation(int orientation)
{
    if(orientation == Qt::WA_Maemo5PortraitOrientation)portraitRadioButton->setChecked(true);
    else landscapeRadioButton->setChecked(true);
}

int SettingsDialog::getColors()
{
    if(normalRadioButton->isChecked()) return 1;
    else return 0;
}

void SettingsDialog::setColors(int colors)
{
    if(colors == 1)normalRadioButton->setChecked(true);
    else invertedRadioButton->setChecked(true);
}

void SettingsDialog::fontChanged(const QString &newfont)
{
    if(!newfont.isEmpty()){
        fontSizeSelector->setModel(fontSizes[newfont]);  
    }
}

void SettingsDialog::setFontFamily(const QString &family)
{
    if(!family.isEmpty()){
        QList<QStandardItem*> list = model->findItems(family);
        if(!list.isEmpty())
            fontSelector->setCurrentIndex(list.first()->row());
        else
            fontSelector->setCurrentIndex(0);
    }
}

QString SettingsDialog::getFontFamily()
{
    if(fontSelector->currentValueText().isEmpty())
        return "Sans";
    return fontSelector->currentValueText();
}

void SettingsDialog::setFontSize(int size)
{
    QStandardItemModel *tmodel = fontSizes[fontSelector->currentValueText()];
    if(tmodel){
        QList<QStandardItem*> list = tmodel->findItems(QString::number(size));
        if(!list.isEmpty())
            fontSizeSelector->setCurrentIndex(list.first()->row());
        else
            fontSizeSelector->setCurrentIndex(0);
    }
}

int SettingsDialog::getFontSize()
{
    QString temp = fontSizeSelector->currentValueText();
    if(temp.toInt() == 0)
        return 20;
    return temp.toInt();
}
