#ifndef SELECTORDIALOG_H
#define SELECTORDIALOG_H

#include <QDebug>
#include <QWidget>
#include <QHBoxLayout>
#include <QListWidget>
#include <QListWidgetItem>

class SelectorDialog : public QWidget
{
    Q_OBJECT
public:
    SelectorDialog(QList<QString> items, QWidget *parent = 0) : QWidget(parent)
    {
        QListWidget *view = new QListWidget(this);
        QHBoxLayout *layout = new QHBoxLayout(); 

        layout->addWidget(view);
        view->setWordWrap(true);

        for(QList<QString>::iterator iter = items.begin(); iter != items.end(); ++iter){
            view->addItem(new QListWidgetItem(*iter));
        }

        connect(view, SIGNAL(itemClicked(QListWidgetItem*)), this, SLOT(itemSelected(QListWidgetItem*)));

        setLayout(layout);

    }

public slots:
    void itemSelected(QListWidgetItem *item)
    {
        emit selectedString(item->text());
        close();
    }

signals:
    void selectedIndex(int);
    void selectedString(QString);

};

#endif
