#ifndef MAINWONDOW_H
#define MAINWONDOW_H

#include <QMainWindow>
#include <QEvent>
#include <QToolBar>
#include <QKeyEvent>
#include "bookview.h"
#include "selectordialog.h"

class MainWindow : public QMainWindow{
    Q_OBJECT
public:
//    MainWindow(const QString &filename, QWidget *parent = 0);
    MainWindow(QWidget *parent = 0);
    ~MainWindow();

    void openBook(const QString &filename);
    void openBook(Book *book);

    void setFont(const QString&, int);
    void setColorMode(int);

protected:
    bool eventFilter(QObject*, QEvent*);
    void keyPressEvent(QKeyEvent*);
    void closeEvent(QCloseEvent*);

private:
    BookView *bookView;
    Book *currentBook;
    SelectorDialog *dialog;
    QToolBar *toolbar;
    void grabZoomKeys(bool);

public slots:
    void tocNavigation();

signals:
    void volumeDownPressed();
    void volumeUpPressed();
};

#endif
