#include "mainwindow.h"
#include "selectordialog.h"
#include <QAction>

#include <QtGui/QX11Info>
#include <X11/Xlib.h>
#include <X11/Xatom.h>

/*MainWindow::MainWindow(const QString &filename, QWidget *parent)
{
    Book *book = new Book(filename);
    MainWindow(book, parent);

}*/

MainWindow::MainWindow(QWidget *parent) : QMainWindow(parent)
{
    bookView = new BookView(this);
    setCentralWidget(bookView); 

/*    currentBook = book;

    bookView->setBook(book);*/

    bookView->installEventFilter(this);

    
    connect(this, SIGNAL(volumeUpPressed()), bookView, SLOT(volumeUpPressed()));
    connect(this, SIGNAL(volumeDownPressed()), bookView, SLOT(volumeDownPressed()));

    toolbar = new QToolBar("toolbar", this);
    QAction *tocAction = toolbar->addAction("TOC");
    tocAction->setIcon(QIcon("/opt/mebook/data/toc_icon.png"));
    connect(tocAction, SIGNAL(triggered()), this, SLOT(tocNavigation()));

    setWindowFlags(windowFlags() | Qt::Window);
    setAttribute(Qt::WA_Maemo5StackedWindow);
    addToolBar(toolbar);
    grabZoomKeys(true);
}

MainWindow::~MainWindow()
{
    grabZoomKeys(false);
}

void MainWindow::openBook(const QString &filename)
{
    Book *book = new Book(filename);
    openBook(book);
}

void MainWindow::openBook(Book *book)
{
    if(bookView)
        bookView->setBook(book);
    currentBook = book;
}

void MainWindow::setFont(const QString &family, int size)
{
    if(bookView)
        bookView->setFont(family, size);
}

void MainWindow::setColorMode(int mode)
{
    if(bookView)
        bookView->setNightMode(mode);
}

bool MainWindow::eventFilter(QObject *object, QEvent *event)
{
    if(event->type() == QEvent::MouseButtonDblClick)
    {
        if(!isFullScreen()){
            showFullScreen();
            toolbar->hide();            
        }
        else{
            showNormal();
            toolbar->show();
        }
    }else {
        return QObject::eventFilter(object, event);
    }
}

void MainWindow::keyPressEvent(QKeyEvent *event)
{
    if(event->key() == Qt::Key_F7)
        emit volumeUpPressed();
    else if(event->key() == Qt::Key_F8)
        emit volumeDownPressed();
    QMainWindow::keyPressEvent(event);
}

void MainWindow::tocNavigation()
{
    QList<QString> toc = currentBook->getTOC();
    dialog = new SelectorDialog(toc, this);
    dialog->setAttribute(Qt::WA_Maemo5StackedWindow);
    dialog->setWindowFlags(dialog->windowFlags() | Qt::Window);
    connect(dialog, SIGNAL(selectedString(QString)), bookView, SLOT(goToChapter(QString)));
    dialog->show();


}


void MainWindow::grabZoomKeys(bool grab)
{
    if(!winId()){
        qDebug("Can't grab keys unless we have a window id");
        return;
    }

    unsigned long val = (grab) ? 1 : 0;
    Atom atom = XInternAtom(QX11Info::display(), "_HILDON_ZOOM_KEY_ATOM", False);
    if(!atom){
        qDebug("Unable to obtain _HILDON_ZOOM_KEY_ATOM.");
        return;
    }

    XChangeProperty(QX11Info::display(),
        winId(),
        atom,
        XA_INTEGER,
        32,
        PropModeReplace,
        reinterpret_cast<unsigned char*>(&val),
        1);

    grabKeyboard();
}

void MainWindow::closeEvent(QCloseEvent *event)
{
    bookView->saveProgress(); 
    QMainWindow::closeEvent(event);
}
