#ifndef BOOKVIEW_H
#define BOOKVIEW_H

#include <QWebView>
#include "book.h"
#include "shared.h"

enum BookViewMode{ScrollingBookMode, ScrollingSectionMode, PageMode};

class BookView : public QWebView
{
    Q_OBJECT
public:
    BookView(QWidget *parent = 0);
    ~BookView();
    void setBook(Book*);
    void goToSection(int);

    void setFont(const QString&, int);
    void setNightMode(bool);

protected:
    void mousePressEvent(QMouseEvent*);
    void mouseMoveEvent(QMouseEvent*);

private:
    Book *book;
    QString currentChapter;
    int currentSection;
    int currentPage;
    QPoint swipeStart;
    BookViewMode viewMode;
    bool snapEnabled;

    QPoint previousOffset;

    QList<QWebElement> hitElements(const QLine&);

    void setContent(QString);

    void parseLinks(QString&);
//    void setCSSWhiteSpaceProperty(QString);
//    void setCSSWhiteSpaceProperty(QWebElement&, QString);
    void setCSSSetting(QString, QString);
    void setHTMLAttribute(QString, QString);
    void makeDOMChangesEffective();
    void setDOMElementSettings(QWebElement&);

    void parseContent(QWebElement&i, QStringList);
    void generatePages(QString);

    QHash<QString, QString> cssSettings;
    QHash<QString, QString> htmlAttributes;
    QHash<QString, QString> margins;
    QHash<QString, QString> linewidths;

    QWebPage *webPage;
    QList<QWebPage*> pages;

public slots:
    void goToChapter(QString);
    void volumeUpPressed();
    void volumeDownPressed();
    void saveProgress();
    void loadingPageFinished(bool);

};

#endif
